﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<EventPost>>" %>
<% int EventApplicationID = ApplicationIDs.Instance().Event(); %>

<div class="tn-box tn-widget tn-widget-content tn-corner-all">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=GetResourceString("Title_LeaveMessage", EventApplicationID)%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <%  if (TempData["StatusMessageType"] != null)
            {
                StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                if (messageType == StatusMessageType.Success)
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 2000, false));
                else
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), false));
                TempData["StatusMessageType"] = null;
            }
            
        %>
    <% int eventID = ViewData.GetInt("EventID", 0);
           if (CurrentUser!=null && EventPermission.Validate(eventID, CurrentUser, PermissionItemKeys.Instance().CreateEventPost()))
           {  %>
    <form id="newCommentForm" method="post" action="<%=SPBUrlHelper.Action("CreateEventPost","ChannelEvent",new RouteValueDictionary{{"eventID",eventID}}) %>">
      <div class="tn-form">
        <div class="tn-comment-form-wrap tn-emotion-box tn-bg-gray">
          <input type="hidden" id="parentID" name="parentID" value="<%=TempData.GetInt("ParentID", 0)%>" />
          <div class="tn-comment-form">
            <div class="tn-comment-form tn-emotion-box">
              <%  Html.RenderAction<ChannelController>(n => n.Control_SmileySelector("smiley", "postBody"));%>
              <div class="tn-comment-text-wrap tn-border-gray tn-form-row-near tn-textarea-wrap">
                <textarea class="tn-comment-text-area" rows="5" cols="60" name="postBody" id="postBody"><%=TempData.GetString("postBody", string.Empty)%></textarea><br />
                <span style="display:none"></span>
              </div>
              <div class="tn-form-row tn-text-note"> <%=GetResourceString("Description_LeaveMessageMaxLimit",EventApplicationID)%></div>
            </div>
            <%SiteSettings settings = SiteSettingsManager.GetSiteSettings();
                      if (settings.VerifyCodeOption == VerifyCodeOption.Enabled || CurrentUser == null && settings.VerifyCodeOption == VerifyCodeOption.Anonymous)
                      { %>
            <div class="tn-form-row tn-form-row-verifycode">
              <label> <%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon") %></label>
              <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode", VerificationCodeDifficultyLevel.Low)%> </div>
            <%} %>
            <div class="tn-form-row tn-form-row-button">
              <label class="tn-form-label"> &nbsp;</label>
              <%=SPBHtmlHelper.Instance().SubmitButton("postButton", GetResourceString("Button_LeaveMessage", EventApplicationID))%>
              <% if (Request.UrlReferrer != null)
                           {%>
              <%=SPBHtmlHelper.Instance().CancelButton( Request.UrlReferrer.AbsoluteUri)%>
              <%} %>
            </div>
          </div>
        </div>
      </div>
    </form>
    <%
            }
           int returnToPageIndex = ViewData.Model.PageIndex;
           if (ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1 && returnToPageIndex != 1)
           {
               returnToPageIndex = ViewData.Model.PageIndex - 1;
           }
           bool IsAdministrator = ViewData.GetBool("IsAdministrator", false);
           bool IsManager = ViewData.GetBool("IsManager", false);
        %>
    <ul class="tn-comments">
      <% foreach (EventPost post in ViewData.Model.Records)
                   {
                       bool hasPermission = false;
                       if (CurrentUser !=null && post.UserID == CurrentUser.UserID && post.UserID > 0 || IsAdministrator || IsManager)
                           hasPermission = true;
                       if (post.AuditingStatus != AuditingStatuses.Success && !hasPermission)
                           continue;
                %>
      <li class="tn-comment-item tn-border-gray tn-border-bottom">
        <div class="tn-comment tn-helper-clearfix">
          <div class="tn-comment-avatar">
            <div class="tn-avatar">
              <%if (post.UserID > 0)
                                  { %>
              <%=SPBHtmlHelper.Instance().ShowUserAvatar(post.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small,null)%>
              <%}
                                  else
                                  { %>
              <%=SPBHtmlHelper.Instance().ShowUserAvatar(post.UserID, false, HyperLinkTarget._blank, AvatarSizeTypes.Small,null)%>
              <%} %>
            </div>
          </div>
          <% if (hasPermission)
                           { %>
          <a href="javascript:;" class="tn-icon tn-icon-cross tn-helper-right" onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteLeaveMessage",EventApplicationID) %>')) { $('#ListEventPosts').load('<%=SPBUrlHelper.Action("DeleteEventPost", "ChannelEvent", new RouteValueDictionary { { "postID", post.PostID },{"eventID",post.EventID},{"pageIndex",returnToPageIndex} })%>' )} "> </a>
          <%} %>
          <div class="tn-comment-info">
            <div class="tn-commentator">
              <h5> <%=SPBHtmlHelper.Instance().UserDisplayNameLink(post.UserID, post.Author, UserDomainSpecialAppIDs.Instance().Home())%> </h5>
              <em class="tn-text-note tn-date"> <%=Formatter.FormatDate(post.PostDate,true) %></em>
               <% if (CurrentUser != null && post.UserID != CurrentUser.UserID)
                           {  %>
                        <span><a href="javascript:;" onclick="$('#postBody').focus(); $('#postBody').attr('value','<%=GetResourceString("Common_Reply") %><%=post.Author %><%=GetResourceString("Common_Colon") %>');$('#parentID').attr('value','<%=post.PostID %>');">
                            <%=GetResourceString("Common_Reply")%></a></span>
                        <%} %>
              
              </div>
               <%if (post.ParentID > 0)
                      { %>
                    <blockquote class="tn-cue-tips tn-bg-gray tn-border-gray">
                        <p>
                            <%=GetResourceString("Common_Reply")%>
                            <a class="tn-author" target="_blank" href="<%=SiteUrls.Instance().UserDomainHome(post.ParentUserID) %>">
                                <%=post.ParentAuthor%></a><em class="tn-text-note tn-date"><%=Formatter.FormatDate(post.ParentPostDate, true)%></em></p>
                        <p>
                            <%=post.ParentBody%></p>
                    </blockquote>
                    <%} %>
            <p> <%=post.Body %> </p>
          </div>
        </div>
      </li>
      <%} %>
    </ul>
    <div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListEventPosts","ChannelEvent",new RouteValueDictionary{{"eventID",eventID},{"pageIndex","{0}"}}), "pageIndexChange")%> </div>
  </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("#newCommentForm").validate({
            rules: {
                verifyCode: { required: true },
                postBody: { required: true, maxBlength: 300 }
            },
            messages: {
                verifyCode: { required: "<%=GetResourceString("Validate_FillInValidate") %>" },
                postBody: { required: "<%=GetResourceString("Validate_InputLeaveMessageBody",EventApplicationID) %>", maxBlength: "<%=GetResourceString("Validate_LeaveMessageMaxLength",EventApplicationID) %>" }
            }
        });
        $("#newCommentForm").ajaxForm({
            beforeSubmit: function() {
                if (!$("#newCommentForm").valid())
                { return false; }
                $('#newCommentForm').block({
                    message: '<%=GetResourceString("Message_Loading")%>'
                });
            },
            target: '#ListEventPosts',
            success: function() {
                $('#newCommentForm').unblock();
            }
        });
        $('.nyroModal').nyroModal({
            resizeable: true
        });
    });
    function pageIndexChange(url) {
        $('#ListEventPosts').load(url);
    }
</script>
