﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<EventThread>>" %>
<% if (ViewData.Model.Count > 0)
   {
   %>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-events-main">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=ViewData.GetString("moduleTitle", GetResourceString("Title_EventModule", ApplicationIDs.Instance().Event()))%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-list tn-helper-clearfix">
      <%foreach (EventThread thread in ViewData.Model)
              {
            %>
      <li class="tn-list-item tn-helper-clearfix">
        <div class="tn-list-item-area-left">
          <div class="tn-avatar"> <%=SPBHtmlHelper.Instance().ShowEventLogo(thread, true, "_self", EventPhotoTypes.SmallLogo)%></div>
        </div>
        <div class="tn-list-item-area-main">
          <div class="tn-list-item-row tn-list-item-heading">
            <h5 class="tn-helper-reset"> <a href="<%=SPBUrlHelper.Action("ShowEvent", "ChannelEvent", new RouteValueDictionary { { "eventID", thread.EventID } })%>" title="<%=thread.EventName %>"> <%=StringUtils.Trim( thread.EventName ,21)%></a></h5>
          </div>
          <div class="tn-list-item-row">
            <p class="tn-date tn-text-note"><%=GetResourceString("Label_Time", ApplicationIDs.Instance().Event())%><%=GetResourceString("Common_Colon")%><%=Formatter.FormatDate(thread.StartTime) %></p>
            <p class="tn-location tn-text-note"><%=GetResourceString("Label_Place", ApplicationIDs.Instance().Event())%><%=GetResourceString("Common_Colon")%><a href="<%=SiteUrls.Instance().ListEventsByAreaCode(thread.AreaCode) %>"><%=Formatter.FormatArea(thread.AreaCode,1,2) %></a></p>
          </div>
        </div>
      </li>
      <%} %>
    </ul>
    <p class="tn-more">
      <%if (ViewData.Model.Count >= ViewData.GetInt("displayItemCount", 0))
              {%>
      <a href="<%=SPBUrlHelper.Action("SecondarySearch", "ChannelEvent", new RouteValueDictionary { { "sortBy", ViewData["sortBy"] },{"areaCode",ViewData["areaCode"]},{ "isClubEvent",ViewData["isClubEvent"] }, { "isEssential", ViewData["isEssential"] },{"status",EventStatuses.Published} })%>"> <%=GetResourceString("Action_More")%></a>
      <%} %>
    </p>
  </div>
</div>
<div class="tn-blank10"> </div>
<%} %>
