﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<EventThread>>" %>
<%if (ViewData.Model.Count > 0)
  {  
  int EventApplicationID = ApplicationIDs.Instance().Event();
  EventStatuses? status = (EventStatuses?)ViewData["status"];%>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-event-title-list">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=ViewData.GetString("moduleTitle",GetResourceString("Title_EventModule",EventApplicationID)) %></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-list">
      <%foreach (EventThread thread in ViewData.Model)
              { 
            %>
      <li class="tn-img-sprite tn-list-bullet"><a href="<%=SiteUrls.Instance().ShowEvent(thread.EventID) %>"
                title="<%=thread.EventName %>"> <%=StringUtils.Trim( thread.EventName ,15)%></a><br />
        <%if (Html.GetParameterFromRouteDateOrQueryString<bool>("isShowTimeAddArea"))
                  { %>
        <em class="tn-date tn-text-note"> <%=EventDateFormatter.FormatDate(thread.StartTime, false)%> </em><em class="tn-location"><a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("Search","ChannelEvent",new RouteValueDictionary{{"areaCode",thread.AreaCode}})) %>"
                    title="<%=string.Format(GetResourceString("Description_Pattern_CheckAllEvent", EventApplicationID), Formatter.FormatArea(thread.AreaCode,true)) %>"> <%=StringUtils.Trim(Formatter.FormatArea(thread.AreaCode,1,2),8)%></a></em><br />
        <%} %>
        <em class="tn-count tn-text-note"> <%=thread.HitTimes %><%=GetResourceString("Label_Scan", ApplicationIDs.Instance().Event())%></em> <em class="tn-count tn-secondary-text"><a href="<%=SPBUrlHelper.Action("ListEventMembers", "ChannelEvent", new RouteValueDictionary { { "eventID", thread.EventID } })%>"> <%=thread.MemberCount %><%=GetResourceString("Label_Attend", ApplicationIDs.Instance().Event())%></a> </em></li>
      <%} %>
    </ul>
    <p class="tn-more">
      <% 
                if (ViewData.Model.Count >= ViewData.GetInt("displayItemCount", 0))
                {%>
      <% if (!string.IsNullOrEmpty(ViewData.GetString("areaCode", string.Empty)))
               { %>
      <a href="<%=SPBUrlHelper.Action("Search", "ChannelEvent", new RouteValueDictionary { { "areaCode", ViewData.GetString("areaCode", string.Empty) },{"status",status} })%>"> <%=GetResourceString("Action_More")%></a>
      <%}
               else
               { %>
      <a href="<%=SPBUrlHelper.Action("SecondarySearch", "ChannelEvent", new RouteValueDictionary { { "sortBy", (EventThreadSortBy?)ViewData["sortBy"] }, { "isClubEvent", (bool?)ViewData["isClubEvent"] }, { "isEssential", (bool?)ViewData["isEssential"] },{"status",status} })%>"> <%=GetResourceString("Action_More")%></a>
      <%}
                } %>
    </p>
  </div>
</div>
<div class="tn-blank10"> </div>
<%} %>
