﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<EventThread>>" %>
<ul class="tn-list tn-helper-reset">
    <% foreach (EventThread thread in ViewData.Model)
       {%>
    <li class="tn-list-item tn-helper-clearfix">
        <div class="tn-list-item-area-left">
            <div class="tn-avatar">
                <%=SPBHtmlHelper.Instance().ShowEventLogo(thread, true, "_self", EventPhotoTypes.SmallLogo)%>
            </div>
        </div>
        <div class="tn-list-item-area-main">
            <div class="tn-list-item-row tn-list-item-heading">
                <h5 class="tn-helper-reset">
                    <a href="<%=SiteUrls.Instance().ShowEvent(thread.EventID) %>" title="<%=thread.EventName %>">
                        <%= StringUtils.Trim(thread.EventName,50) %></a>
                </h5>
            </div>
            <div class="tn-list-item-row tn-list-item-summary">
                <p class="tn-helper-reset">
                    <%=HtmlUtils.TrimHtml(thread.Excerpt, 23)%></p>
            </div>
        </div>
    </li>
    <%}  %>
</ul>
