﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<EventMember>>" %>
<%
    int EventApplicationID = ApplicationIDs.Instance().Event();
    int UserApplicationID = ApplicationIDs.Instance().User();
    bool? isApproved = (bool?)ViewData["IsApproved"];
    int userID = ViewData.GetInt("UserID", 0);
    int eventID = ViewData.GetInt("EventID", 0);

 
%>
<div id="ManageEventMembers">
    <%  StatusMessageData statusMessageContent = TempData.Get<StatusMessageData>("StatusMessageContent", null);
        if (statusMessageContent != null)
        {
            if (statusMessageContent.MessageType == StatusMessageType.Success)
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageContent, 3000, false));
            else
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageContent));
            statusMessageContent = null;
        } %>
    <div id="imitateTabs" class="ui-tabs ui-widget ui-widget-content ui-corner-all spb-event-members">
        <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all"
            id="ManageEventMembers-Tabs">
            <li class="ui-state-default ui-corner-top <%if(!isApproved.HasValue) Response.Write("ui-tabs-selected ui-state-active"); %>">
                <a href="javascript:;"><span>
                    <%=GetResourceString("Action_AllEventMember",EventApplicationID)%></span></a></li>
            <li class="ui-state-default ui-corner-top <%if(isApproved.HasValue && isApproved.Value==true) Response.Write("ui-tabs-selected ui-state-active"); %>">
                <a href="javascript:;" value="true"><span>
                    <%=GetResourceString("Action_Approved", EventApplicationID)%></span> </a>
            </li>
            <li class="ui-state-default ui-corner-top  <%if(isApproved.HasValue && isApproved.Value==false) Response.Write("ui-tabs-selected ui-state-active"); %>">
                <a href="javascript:;" value="false"><span>
                    <%=GetResourceString("Action_NoApproved", EventApplicationID)%></span> </a>
            </li>
            <li class="ui-state-default ui-corner-top"><a id="NoReply" href="javascript:;"><span>
                <%=GetResourceString("Title_ManageNo",ApplicationIDs.Instance().Event())%></span>
            </a></li>
        </ul>
        <div class="ui-tabs-panel ui-widget-content ui-corner-bottom">
            <div class="tn-list-header">
                <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                    <div class="tn-search-box tn-helper-right">
                        <form id="ManageSearchForm" method="get">
                        <input type="text" name="keyWord" id="keyWord" value="<%=Html.GetParameterFromRouteDateOrQueryString("keyWord") %>"
                            class="tn-search-input tn-input-medium tn-border-gray tn-border-tbl">
                        <span class="tn-search-button tn-search-ico-button tn-border-gray tn-bg-gray">
                            <button onclick="$('#ManageSearchForm').submit();">
                                <span class="tn-icon tn-icon-find"></span>
                            </button>
                        </span>
                        <input id="eventID" name="eventID" value="<%=eventID %>" type="hidden" />
                        </form>
                    </div>
                    <span class="tn-action"><a class="tn-action-text" href="<%=SPBUrlHelper.Action("EventInvitation","ChannelEvent",new RouteValueDictionary{{"eventID",eventID}}) %>">
                        <%=GetResourceString("Action_InvitationFriend")%></a></span><span class="tn-pipe tn-text-note">|</span><span
                            class="tn-action"><a class="tn-action-text" href="<%=SiteUrls.Instance().ExportEventMembersToCSV(eventID,isApproved) %>">
                                <%=GetResourceString("Action_EduceEventMemberMenu",EventApplicationID)%></a>
                        </span>
                </div>
            </div>
            <ul class="tn-list tn-helper-reset">
                <% 
                    
                    foreach (EventMember member in ViewData.Model.Records)
                    { %>
                <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                    <div class="tn-list-item-area-left">
                        <div class="tn-avatar">
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(member.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small,null)%>
                        </div>
                    </div>
                    <%if (CurrentUser != null && member.UserID != CurrentUser.UserID && member.UserID != userID)
                      { %>
                    <div class="tn-list-item-area-right">
                        <ul class="tn-list-actions tn-helper-reset">
                            <%
                                string updateEventMemberIsManagerUrl = SPBUrlHelper.Action("UpdateEventMemberIsManager", "ChannelEvent", new RouteValueDictionary { { "memberID", member.MemberID }, { "isManager", !member.IsManager }, { "isApproved", ViewData.GetBool("isApproved", true) }, { "pageIndex", ViewData.Model.PageIndex } });
                                int returnToPageIndex = ViewData.Model.PageIndex;//删除成员后需返回的页序
                                if (ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1 && returnToPageIndex != 1)
                                {
                                    returnToPageIndex = ViewData.Model.PageIndex - 1;
                                }
                                string deleteEventMamberUrl = SPBUrlHelper.Action("DeleteEventMember", "ChannelEvent", new RouteValueDictionary { { "memberID", member.MemberID }, { "isApproved", isApproved }, { "pageIndex", returnToPageIndex } });
                                string approveEventMamberUrl = SPBUrlHelper.Action("ApproveEventMember", "ChannelEvent", new RouteValueDictionary { { "memberID", member.MemberID }, { "isApproved", isApproved }, { "pageIndex", ViewData.Model.PageIndex } });

                                if (member.IsApproved && member.UserID > 0 && CurrentUser.UserID == userID)
                                { %>
                            <li class="tn-list-action tn-border-gray tn-border-bottom"><a href="javascript:;"
                                id="updateIsManager" onclick="
                    <% if(!member.IsManager){ %>
                    if (confirm('<%=GetResourceString("Message_ConfirmSetAdministrator", EventApplicationID) %>'))<%} %>
                    $('#ManageEventMembers').load('<%=updateEventMemberIsManagerUrl %>');">
                                <% if (member.IsManager) Response.Write(GetResourceString("Action_CancelAdministrator", EventApplicationID)); else Response.Write(GetResourceString("Action_SetAdministrator", EventApplicationID)); %></a></li>
                            <%}%>
                            <%  if (!member.IsApproved)
                                { %>
                            <li class="tn-list-action tn-border-gray tn-border-bottom"><a href="javascript:;"
                                name="approveEventMamber" onclick="
                             $('#ManageEventMembers').load('<%=approveEventMamberUrl %>');">
                                <%=GetResourceString("Button_Approve") %></a></li>
                            <%} %>
                            <% if (member.UserID > 0)
                               { %>
                            <li class="tn-list-action tn-border-gray tn-border-bottom"><a href="<%=SPBUrlHelper.Action("NewMessage","MessageCenter",new RouteValueDictionary{{"userDomainName",Globals.GetCurrentUser().UserName},{"toUserID",member.UserID}}) %>"
                                target="_blank">
                                <%= GetResourceString("Action_SendPrivateMessage")%></a></li>
                            <%} %>
                            <% if (!member.IsManager || CurrentUser.UserID == userID)
                               { %>
                            <li class="tn-list-action tn-border-gray tn-border-bottom"><a href="javascript:;"
                                name="deleteEventMamber" onclick="
                             if (confirm('<%=GetResourceString("Message_ConfirmDeleteMember", EventApplicationID) %>'))
                             $('#ManageEventMembers').load('<%=deleteEventMamberUrl %>');">
                                <%=GetResourceString("Action_Delete")%></a></li>
                            <%} %>
                        </ul>
                    </div>
                    <%} %>
                    <div class="tn-list-item-area-main">
                        <div class="tn-list-item-row tn-list-item-heading">
                            <h5 class="tn-helper-reset">
                                <% if (member.UserID > 0)
                                   { %>
                                <a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(member.UserID,UserDomainSpecialAppIDs.Instance().Home()) %>">
                                    <%=SPBHtmlHelper.Instance().UserDisplayName(member.UserID)%></a>
                                <%}
                                   else Response.Write(member.DisplayName); %>
                            </h5>
                        </div>
                        <div class="tn-list-item-row">
                            <div class="tn-info-part">
                                <dl>
                                    <dt class="tn-text-note">
                                        <%=GetResourceString("Label_PersonUserGender", UserApplicationID)%><%=GetResourceString("Common_Colon") %></dt>
                                    <dd>
                                        <%if (member.Gender == Genders.Female) Response.Write(GetResourceString("Enum_Genders_Female")); else Response.Write(GetResourceString("Enum_Genders_Male")); %></dd>
                                </dl>
                                <%if (member.BringCount > 0)
                                  { %>
                                <dl>
                                    <dt class="tn-text-note">
                                        <%=GetResourceString("Label_CarryNumber",EventApplicationID) %><%=GetResourceString("Common_Colon") %></dt>
                                    <dd>
                                        <%=member.BringCount %></dd>
                                </dl>
                                <%} %>
                                <%if (!string.IsNullOrEmpty(member.Email))
                                  { %>
                                <dl>
                                    <dt class="tn-text-note">
                                        <%=GetResourceString("Label_Email")%><%=GetResourceString("Common_Colon") %></dt><dd><%=member.Email%></dd></dl>
                                <%}
                                  if (!string.IsNullOrEmpty(member.Moblie))
                                  { %>
                                <dl>
                                    <dt class="tn-text-note">
                                        <%=GetResourceString("Label_PersonUserMobile", UserApplicationID)%><%=GetResourceString("Common_Colon") %></dt><dd><%=member.Moblie%></dd></dl>
                                <%}
                                  if (!string.IsNullOrEmpty(member.Telephone))
                                  { %>
                                <dl>
                                    <dt class="tn-text-note">
                                        <%=GetResourceString("Label_PersonUserTel", UserApplicationID)%><%=GetResourceString("Common_Colon") %></dt><dd><%=member.Telephone%></dd></dl>
                                <%} %>
                                <% string roleName = string.Empty;
                                   if (member.UserID == userID)
                                       roleName = GetResourceString("Description_EventReleaseUser", EventApplicationID);
                                   else if (member.IsManager)
                                       roleName = GetResourceString("Description_EventAdministrator", EventApplicationID);
                                   else
                                       roleName = GetResourceString("Description_EventMember", EventApplicationID);
                        
                                %>
                                <dl>
                                    <dt class="tn-text-note">
                                        <%=GetResourceString("Label_Degree",EventApplicationID) %><%=GetResourceString("Common_Colon") %><dt>
                                            <span>
                                                <%=roleName%></span>
                                </dl>
                                <% if (!string.IsNullOrEmpty(member.Company))
                                   { %>
                                <dl>
                                    <dt class="tn-text-note">
                                        <%=GetResourceString("Label_PersonUserCompany", UserApplicationID)%><%=GetResourceString("Common_Colon") %><dt><dd><%=member.Company%></dd></dl>
                                <%}
                                   if (!string.IsNullOrEmpty(member.Job))
                                   { %>
                                <dl>
                                    <dt class="tn-text-note">
                                        <%=GetResourceString("Label_PersonUserJob", UserApplicationID)%><%=GetResourceString("Common_Colon") %><dt><dd><%=member.Job%></dd></dl>
                                <%}
                                   if (!string.IsNullOrEmpty(member.Address))
                                   { %>
                                <dl>
                                    <dt class="tn-text-note">
                                        <%=GetResourceString("Label_PersonUserAddress", UserApplicationID)%><%=GetResourceString("Common_Colon") %><dt><dd><%=member.Address%></dd></dl>
                                <%}%>
                                <% if (!string.IsNullOrEmpty(member.RequestBody))
                                   { %>
                                <dl>
                                    <dt class="tn-text-note">
                                        <%=GetResourceString("Label_ApplyLeaveMessage", EventApplicationID)%><%=GetResourceString("Common_Colon") %><dt><dd><%=member.RequestBody%></dd></dl>
                                <%} %>
                                <% if (!string.IsNullOrEmpty(member.Remark))
                                   { %>
                                <dl>
                                    <dt class="tn-text-note">
                                        <%=GetResourceString("Label_Annotations", EventApplicationID)%><%=GetResourceString("Common_Colon") %><dt><dd><%=member.Remark%></dd></dl>
                                <%} %>
                            </div>
                        </div>
                    </div>
                </li>
                <%} %>
            </ul>
        </div>
        <div class="tn-pagination tn-helper-align-center">
            <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11,SPBUrlHelper.Action("Control_ManageEventMembers", "ChannelEvent", new RouteValueDictionary { { "eventID", ViewData.GetInt("EventID", 0) }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
            <div class="tn-page-results tn-text-note">
                <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"),ViewData.Model.TotalRecords) %>
            </div>
        </div>
        <script type="text/javascript">
        $(document).ready(function() {
        if(!$("#keyWord").val())
         $("#keyWord").watermark('<%=GetResourceString("Message_WriteKeyWords",ApplicationIDs.Instance().Event())%>');
         
            $("#ManageEventMembers-Tabs a:not(#NoReply)").click(function() {
            $('#ManageEventMembers').parent().load("<%=SPBUrlHelper.Action("Control_ManageEventMembers","ChannelEvent",new RouteValueDictionary{{"eventID",eventID}}) %>",{isApproved:$(this).attr("value")});
            });
            
              $("#NoReply").click(function() {
             $('#ManageEventMembers').parent().load("<%=SPBUrlHelper.Action("Control_NotReplyMembers", "ChannelEvent", new RouteValueDictionary { { "eventID", eventID } })%>");
            });
            
                 $("#ManageSearchForm").submit(function() {
             $('#ManageSearchForm').ajaxSubmit(
             {
                 target: '#ManageEventMembers',
                 url: '<%=SPBUrlHelper.Action("Control_ManageEventMembers", "ChannelEvent", new RouteValueDictionary { { "eventID", eventID }, { "isApproved", isApproved },{"pageIndex",Html.GetParameterFromRouteDateOrQueryString("pageIndex",0)} })%>'
             });
                 return false;
             });

       
        });
        function pageIndexChange(url) {
            $('#ManageEventMembers').parent().load(url);
        }

        </script>
    </div>
</div>
