﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%int eventID = ViewData.GetInt("eventID", 0); 
 int applicationID=ApplicationIDs.Instance().Event();
    %>
<form id="massSystemMessageForm" name="massSystemMessageForm" class="tn-helper-reset nyroModal"
action="<%=SPBUrlHelper.Action("MassMessageAction","ChannelEvent",new RouteValueDictionary {{"eventID",eventID}}) %>"
method="post">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        <%=GetResourceString("Title_SendNotice",applicationID)%>
    </h4>
    <%
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageData", string.Empty), 3000, false));
            //StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);

            //关闭模式窗口
            if(messageType==StatusMessageType.Success)
                Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));

            TempData["StatusMessageType"] = null;
        }
        else
        {
    %>
    <div class="tn-cue-highlight tn-corner-all tn-message-box">
        <span class="tn-helper-left">
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.Exclamation) %></span>
        <div class="tn-helper-flowfix">
        <%int myCreditPoints = CurrentUser != null ? CurrentUser.TradePoints : 0; %>
            <%=string.Format(GetResourceString("Message_ReduceScore", applicationID),myCreditPoints)%></div>
    </div>
    <%} %>
    <br />
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_TransmitMethod",applicationID)%><%=GetResourceString("Common_Colon")%></label>
        <input type="radio" id="usePrivateMessage" checked="checked" name="transportMode"
            class="tn-radiobutton" value="0" /><label for="usePrivateMessage"><%=GetResourceString("Label_LeaveMessage",applicationID)%></label>
        <input type="radio" id="useEmail" name="transportMode" value="1" class="tn-radiobutton" /><label
            for="useEmail"><%=GetResourceString("Label_LeaveEmail",applicationID)%></label>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_Subject")%><%=GetResourceString("Common_Colon") %>
        </label>
        <input type="text" id="subject" name="subject" class="tn-textbox tn-input-long tn-border-gray" />
    </div>
    <div class="tn-form-row tn-textarea-wrap">
        <label class="tn-form-label">
            <%=GetResourceString("Label_Body")%><%=GetResourceString("Common_Colon") %>
        </label>
        <textarea name="body" id="body" cols="60" rows="8" class="tn-textarea tn-input-long tn-border-gray"></textarea><span style="display:none"></span>
        <div class="tn-text-note">
            <%=GetResourceString("Message_WordcountLimate",applicationID)%>
        </div>
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <%=SPBHtmlHelper.Instance().SubmitButton("sendButton", GetResourceString("Button_Send"), ButtonSizes.Default, null, null)%>
        <%=SPBHtmlHelper.Instance().CancelButton(ButtonSizes.Default, new RouteValueDictionary { { "onclick" ,"$.nyroModalRemove();"} })%>
    </div>
</div>
</form>

<script type="text/javascript">

    $(document).ready(function() {
        $("#massSystemMessageForm").validate({
            rules: {
                subject: { required: true, rangelength: [1, 20]  },
                                body: { required: true, rangelength: [1, 30000]  }

            },
            messages: {
                subject: { required: "<%=GetResourceString("Description_Required")%>",rangelength: "不能大于20个字符！"  },
                body: { required: "<%=GetResourceString("Description_Required")%>",rangelength: "不能大于3000个字符！"  }

            }
        });

        $("#sendButton").click(function() {
            if (!$("#massSystemMessageForm").valid()) {
                return false;
            }
        });
    }); 
</script>

