﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    int EventApplicationID = ApplicationIDs.Instance().Event();
    int UserApplicationID = ApplicationIDs.Instance().User();
    int eventID = ViewData.GetInt("EventID", 0);
%>
<div id="NoReplyMembers">
    <div id="imitateTabs" class="ui-tabs ui-widget ui-widget-content ui-corner-all spb-event-members">
        <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all"
            id="ManageEventMembers-Tabs">
            <li class="ui-state-default ui-corner-top"><a href="javascript:;"><span>
                <%=GetResourceString("Action_AllEventMember",EventApplicationID)%></span></a></li>
            <li class="ui-state-default ui-corner-top"><a href="javascript:;" value="true">
                <span>
                    <%=GetResourceString("Action_Approved", EventApplicationID)%></span> </a>
            </li>
            <li class="ui-state-default ui-corner-top"><a href="javascript:;" value="false">
                <span>
                    <%=GetResourceString("Action_NoApproved", EventApplicationID)%></span> </a>
            </li>
            <li class="ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a id="NoReply"
                href="javascript:;" value="false"><span><%=GetResourceString("Title_ManageNo", EventApplicationID)%></span> </a></li>
        </ul>
        <div class="ui-tabs-panel ui-widget-content ui-corner-bottom">
            <div class="tn-list-header">
                <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                    <div class="tn-search-box tn-helper-right">
                        <span>
                            <%//=string.Format(GetResourceString("Description_Pattern_SumInvite", EventApplicationID), invitations.Count)%>
                        <%=GetResourceString("Description_AlreadyInviteFriend",EventApplicationID)%></span>
                    </div>
                    <span class="tn-action"><a class="tn-action-text" href="<%=SPBUrlHelper.Action("EventInvitation","ChannelEvent",new RouteValueDictionary{{"eventID",eventID}}) %>">
                        <%=GetResourceString("Action_InvitationFriend")%></a></span><span class="tn-pipe tn-text-note">|</span><span
                            class="tn-action"><a class="tn-action-text" href="<%=SiteUrls.Instance().ExportEventMembersToCSV(eventID,null) %>">
                                <%=GetResourceString("Action_EduceEventMemberMenu",EventApplicationID)%></a>
                        </span>
                </div>
            </div>
            <div id="ListInvitations">
                <% Html.RenderAction<ChannelEventController>(n => n.Control_EventInvitationOutBox(eventID, null)); %>
            </div>
        </div>

        <script type="text/javascript">
   
     $(document).ready(function() {
            $("#ManageEventMembers-Tabs a:not(#NoReply)").click(function() {
            $('#NoReplyMembers').parent().load("<%=SPBUrlHelper.Action("Control_ManageEventMembers","ChannelEvent",new RouteValueDictionary{{"eventID",eventID}}) %>",{isApproved:$(this).attr("value")});
            });
            
           
        });
        </script>

    </div>
</div>
