﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<EventPhoto>>" %>
<div id="ListRandomPhotos" class="tn-box tn-widget tn-widget-content tn-corner-all spb-event-photos-main">
    <% string controlUrl = SPBUrlHelper.Action("Control_RandomPhotos", "ChannelEvent", new RouteValueDictionary { { "displayItemCount", Html.GetParameterFromRouteDateOrQueryString("displayItemCount", 0) } });%>
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <span class="tn-helper-right"><a href="javascript:;" onclick="$('#ListRandomPhotos').parent().load('<%=controlUrl %>');"
            >
            <%=GetResourceString("Action_Refurbish",ApplicationIDs.Instance().Event())%></a></span>
        <h3 class="tn-helper-reset">
            <%=GetResourceString("Title_EventPhoto",ApplicationIDs.Instance().Event()) %></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-photo-list tn-widget tn-helper-clearfix">
            <%
                foreach (EventPhoto photo in ViewData.Model)
                {
            %>
            <li class="tn-photo-item">
                <p class="tn-photo-wrap tn-widget-content tn-border-gray">
                    <a href="<%=SiteUrls.Instance().ShowEventPhoto(photo.AttachmentID) %>">
                        <img src="<%=SiteUrls.Instance().EventPhotoUrl(photo.AttachmentID, EventPhotoTypes.Thumbnail) %>"
                            title="<%=photo.FriendlyFileName %>" alt="<%=photo.FriendlyFileName %>" /><span></span></a></p>
            </li>
            <%} %>
        </ul>
    </div>
</div>
<div class="tn-blank10">
</div>
