﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<RecommendedItem>>" %>
<% //List<EventThread> recommendedEvents = ViewData["recommendedEvents"] as List<EventThread>;
    EventThread thread = null;
    bool hasBorder = Html.GetParameterFromRouteDateOrQueryString<bool>("hasBorder");

    if (Model != null && Model.Count > 0)
    {
        if (hasBorder)
        {
%>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-recommended-events">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset">
      <%if (ViewData["RecommendationType"] != null)
              {
                  RecommendationType recommendationType = ViewData.Get<RecommendationType>("recommendationType");
                  Response.Write(recommendationType.GetMultilingualRecommendationTypeName(CurrentUserLanguage));
              }
            %>
    </h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-avatar-medium-list tn-helper-clearfix" id="EventDiv">
      <%foreach (RecommendedItem item in Model)
              {
                  thread = EventThreads.GetEvent(item.ItemID, true);
                  if (thread != null)
                  {
            %>
      <li class="tn-avatar-item">
        <div class="tn-avatar-medium" value="<%=thread.EventID %>"> <%=SPBHtmlHelper.Instance().ShowEventLogo(thread, true, "_self", EventPhotoTypes.Thumbnail)%> </div>
        <a class="tn-text-heading" href="<%=SPBUrlHelper.Action("ShowEvent","ChannelEvent",new RouteValueDictionary{{"eventID",thread.EventID}}) %>"
                    title="<%=thread.EventName %>"> <%=string.IsNullOrEmpty(item.ItemName)? StringUtils.Trim(thread.EventName, 8):StringUtils.Trim(item.ItemName,8)%></a> </li>
      <%}
              } %>
    </ul>
  </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("div.tn-avatar-medium", $("#EventDiv")).each(function() {
            var self = $(this);
            self.qtip({
                content: '<div class="tn-loading"></div>',
                position: {
                    corner: {
                        target: 'rightTop', // Position the tooltip above the link
                        tooltip: 'leftTop'
                    },
                    adjust: {
                        screen: true // Keep the tooltip on-screen at all times
                    }
                },
                show: {
                    when: 'mouseover',
                    solo: true,
                    delay: 1000
                },
                hide: { when: 'mouseout', fixed: true, delay: 480 },
                api: { onShow: function() {
                    if (self.qtip('api').elements.content.is(":has(div.tn-loading)"))
                        $.get('<%=SPBUrlHelper.Action("Control_EventCard", "ChannelEvent")%>', { EventID: self.attr("value") }, function(data) {
                            self.qtip('api').updateContent(data);
                        });
                }
                },
                style: {
                    tip: false, // Apply a speech bubble tip to the tooltip at the designated tooltip corner
                    border: {
                        width: 0,
                        radius: 0
                    },
                    background: 'none',
                    name: 'light', // Use the default light style
                    width: 325, // Set the tooltip width
                    padding: 1
                }
            });
        });
    });
</script>
<div class="tn-blank10"> </div>
<%
    }
        else
        {%>
<ul class="tn-list">
  <%foreach (RecommendedItem item in Model)
      {
          thread = EventThreads.GetEvent(item.ItemID, true);
          if (thread != null)
          {
    %>
  <li class="tn-list-item tn-helper-clearfix">
    <div class="tn-list-item-area-left" value="<%=thread.EventID %>"> <%=SPBHtmlHelper.Instance().ShowEventLogo(thread, true, "_self", EventPhotoTypes.SmallLogo)%> </div>
    <div class="tn-list-item-area-main">
      <div class="tn-list-item-row tn-list-item-heading">
        <h5 class="tn-helper-reset"> <a href="<%=SPBUrlHelper.Action("ShowEvent","ChannelEvent",new RouteValueDictionary{{"eventID",thread.EventID}}) %>"
                        title="<%=thread.EventName %>"> <%=string.IsNullOrEmpty(item.ItemName)? StringUtils.Trim(thread.EventName, 15):StringUtils.Trim(item.ItemName,15)%></a> </h5>
      </div>
      <div class="tn-list-item-row tn-list-item-summary">
        <p class="tn-helper-reset"> <%=HtmlUtils.TrimHtml(thread.GetBody(false),30) %> </p>
      </div>
    </div>
  </li>
  <%}
      } %>
</ul>
<%}
    } %>
