﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<EventPhoto>>" %>
<% int pageIndex = ViewData.Model.PageIndex;
   int EventApplicationID = ApplicationIDs.Instance().Event();
   int eventID = ViewData.GetInt("EventID", 0);

%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-event-photo-show">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <span class="tn-helper-right">
            <%if (CurrentUser != null && EventPermission.Validate(eventID, CurrentUser, PermissionItemKeys.Instance().UploadEventPhoto()))
              { %>
            <a href="<%=SPBUrlHelper.Action("UploadEventPhotos", "ChannelEvent", new RouteValueDictionary {{"eventID",eventID} })%>">
                <%=GetResourceString("Action_OnloadPhoto", EventApplicationID)%></a> <span class="tn-seperator">
                    |</span>
            <%} %>
            <a href="<%=SPBUrlHelper.Action("ListEventPhotos","ChannelEvent",new RouteValueDictionary{{"eventID",ViewData.GetInt("EventID",0)}}) %>">
                <%=GetResourceString("Action_AllPhotos",EventApplicationID)%></a> </span>
        <h3 class="tn-helper-reset">
            <%=string.Format(GetResourceString("Title_Pattern_SomebodyPhoto",EventApplicationID),ViewData.GetString("EventName",string.Empty))%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <% EventPhoto eventPhoto = null;
           if (ViewData.Model.Records != null && ViewData.Model.Records.Count > 0)
               eventPhoto = ViewData.Model.Records[0];
           else if (ViewData["EventPhoto"] != null)
               eventPhoto = ViewData["EventPhoto"] as EventPhoto;
           if (eventPhoto != null)
           { %>
        <div class="spb-photo-main">
            <% if (ViewData.Model.Records != null)
               { %>
            <div class="tn-list-header">
                <div class="tn-list-header-row tn-helper-clearfix tn-helper-align-right tn-border-gray tn-border-bottom">
                    <span class="tn-text-note tn-helper-left">
                        <%=string.Format(GetResourceString("Description_Pattern_CurrentSheetAndAllSheet", EventApplicationID), ViewData.Model.PageIndex, ViewData.Model.TotalRecords)%></span>
                    <%if (ViewData.Model.PageIndex > 1)
                      {  %>
                    <span class="tn-action tn-action-text-icon"><span class="tn-icon tn-icon-triangle-left">
                    </span><a href="javascript:;" class="tn-action-text" onclick="$('#ShowEventPhotoDiv').load('<%=SPBUrlHelper.Action("Control_ShowEventPhoto", "ChannelEvent", new RouteValueDictionary { { "eventID", ViewData.GetInt("EventID", 0) },{"pageIndex",pageIndex-1} })%>');">
                        <%=GetResourceString("Action_LastSheet", EventApplicationID)%></a></span>
                    <%} if (ViewData.Model.TotalRecords > ViewData.Model.PageIndex * ViewData.Model.PageSize)
                      { %>
                    <span class="tn-action tn-action-text-icon-right"><span class="tn-icon tn-icon-triangle-right">
                    </span><a class="tn-action-text" href="javascript:;" onclick="$('#ShowEventPhotoDiv').load('<%=SPBUrlHelper.Action("Control_ShowEventPhoto","ChannelEvent",new RouteValueDictionary{{"eventID",ViewData.GetInt("EventID",0)},{"pageIndex",pageIndex+1}}) %>');">
                        <%=GetResourceString("Action_NextSheet", EventApplicationID)%></a></span>
                    <%} %>
                </div>
            </div>
            <%}%>
            <%bool errorAuditingStatus = ViewData.GetBool("errorAuditingStatus", false);
              if (errorAuditingStatus)
              {
                  string errorMessage = ViewData.GetString("errorMessage", string.Empty);%>
            <div class="tn-blank10">
            </div>
            <div class="tn-widget">
                <div class="tn-cue-highlight tn-corner-all tn-message-box">
                    <span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("ListEventPhotos", "ChannelEvent", new RouteValueDictionary { { "eventID", eventID} })%>">
                        返回活动相册</a></span> <span class="tn-helper-left"><span class="tn-icon tn-icon-exclamation">
                        </span></span>
                    <div class="tn-helper-flowfix">
                        <%=errorMessage%>
                    </div>
                </div>
            </div>
            <div class="tn-blank10">
            </div>
            <%}
              if (!errorAuditingStatus || (CurrentUser != null && CurrentUser.IsContentAdministrator))
              {%>
            <div class="spb-photo-container">
                <% int nextPageIndex = 1;
                   if (ViewData.Model.TotalRecords > ViewData.Model.PageIndex * ViewData.Model.PageSize)
                       nextPageIndex = pageIndex + 1; %>
                <img src="<%=SiteUrls.Instance().EventPhotoUrl(eventPhoto.AttachmentID, EventPhotoTypes.Details) %>"
                    title="<%=GetResourceString("Description_HitTimesCheckSeeNextPhoto",EventApplicationID) %>"
                    alt="<%=eventPhoto.FriendlyFileName %>" onclick="$('#ShowEventPhotoDiv').load('<%=SPBUrlHelper.Action("Control_ShowEventPhoto","ChannelEvent",new RouteValueDictionary{{"eventID",ViewData.GetInt("EventID",0)},{"pageIndex",nextPageIndex}}) %>');" />
            </div>
            <h2>
                <%=eventPhoto.FriendlyFileName%></h2>
            <%if (CurrentUser != null && EventPermission.ValidateEventPhoto(eventPhoto, CurrentUser))
              {%>
            <div class="tn-actions tn-helper-align-right">
                <span class="tn-action"><a href="javascript:;" onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteEventPhoto",EventApplicationID) %>')) 
        { window.location.href='<%=SPBUrlHelper.Action("DeleteEventPhoto","ChannelEvent",new RouteValueDictionary{{"attachmentID",eventPhoto.AttachmentID}}) %>'}">
                    <%=GetResourceString("Action_Delete")%></a> </span><span class="tn-action"><a id="editEventPhoto"
                        href="<%=SPBUrlHelper.Action("Control_EditEventPhoto","ChannelEvent",new RouteValueDictionary{{"attachmentID",eventPhoto.AttachmentID}}) %>">
                        <%=GetResourceString("Action_Edit")%></a> </span>
            </div>
            <%} %>
            <%if (!string.IsNullOrEmpty(eventPhoto.Description))
              { %>
            <div class="tn-detail-text">
                <%=HtmlUtils.TrimHtml(eventPhoto.Description, 3000)%>
            </div>
            <%} %>
            <div class="spb-event-photo-info">
                <%=GetResourceString("Description_By", EventApplicationID)%>
                <%=SPBHtmlHelper.Instance().UserDisplayNameLink(eventPhoto.UserID, eventPhoto.Author, UserDomainSpecialAppIDs.Instance().Home())%>
                <%=GetResourceString("Description_OnloadFor", EventApplicationID)%>
                <%=Formatter.FormatDateToIntervalTime(eventPhoto.DateCreated)%>
                <%=SPBHtmlHelper.Instance().LinkButton("comment", GetResourceString("Common_Comment") + eventPhoto.CommentCount, "#Comment", ButtonSizes.Default, HighlightStyles.Lite, IconTypes.Bubble, TextIconLayout.IconText)%>
            </div>
            <% Html.RenderAction<ChannelEventController>(n => n.Control_ListEventPhotoComments(eventPhoto.AttachmentID, 1)); %>
            <%} %>
        </div>
        <%} %>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $('#editEventPhoto').nyroModal({
            endRemove: function () { $('#ShowEventPhotoDiv').load('<%=SPBUrlHelper.Action("Control_ShowEventPhoto","ChannelEvent",new RouteValueDictionary{{"eventID",ViewData.GetInt("EventID",0)},{"pageIndex",pageIndex}}) %>'); }
        });
    }); 
</script>
