﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% int threadID = Html.GetParameterFromRouteDateOrQueryString<int>("threadID"); %>
<div id="attachmentListContainer">
    <div class="spb-photos-manage spb-insert-have-been">
        <div class="tn-cue-highlight tn-corner-all tn-message-box" style="display: none">
            <div class="tn-helper-flowfix" id="uploadMessage">
            </div>
        </div>
        <div class="tn-blank10">
        </div>
        <div class="tn-list-header">
            <div class="tn-list-header-row tn-border-gray tn-border-bottom">
                <a id="uploadAttachmentLink" href="javascript:;">
                    <%=GetResourceString("Action_GoUpload")%></a>
            </div>
        </div>
        <div id="ManageThreadAttachmentsDiv">
            <% Html.RenderAction<ChannelEventController>(n => n.Control_ManageThreadAttachments(threadID)); %>
        </div>
    </div>
</div>

<script type="text/javascript">
    function queueCompleteHandler(numFilesUploaded) {
        $("#uploadAttachmentContainer").hide();
        $("#attachmentListContainer").show();
        if (numFilesUploaded && numFilesUploaded > 0) {
            $.ajaxSetup({ cache: false });
            $("#ManageThreadAttachmentsDiv").load('<%=SPBUrlHelper.Action("Control_ManageThreadAttachments", "ChannelEvent", new RouteValueDictionary {{ "threadID", threadID }}) %>');
            $("#uploadMessage", $("#attachmentListContainer")).html(numFilesUploaded + '<%=GetResourceString("Message_FileUploadAlready",ApplicationIDs.Instance().File())%>').parent(".tn-cue-highlight").show();
        }
        else if (numFilesUploaded == 0)
            $("#uploadMessage", $("#attachmentListContainer")).html('<%=GetResourceString("Message_FileUploadError",ApplicationIDs.Instance().File()) %>').parent(".tn-cue-highlight").show();
        setTimeout(function() { $("#uploadMessage", $("#attachmentListContainer")).parent(".tn-cue-highlight").hide(); }, 3000);
    }
</script>

<div id="uploadAttachmentContainer" style="display: none">
    <%  Html.RenderAction<ChannelEventController>(n => n.Control_UploadEventAttachment(threadID, "queueCompleteHandler")); %>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("#uploadAttachmentLink", $("#attachmentListContainer")).click(function() {
            $("#attachmentListContainer").hide();
            $("#uploadAttachmentContainer").show();
        });
        if (!$("#ManageThreadAttachmentsDiv", $("#attachmentListContainer")).find(".tn-photo-item").length) {
            $("#uploadAttachmentLink", $("#attachmentListContainer")).click();
        }
    });
</script>