﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<FileComment>>" %>
<%
    PagingDataSet<FileComment> comments = (PagingDataSet<FileComment>)ViewData.Model;
    FileThread file = (FileThread)ViewData["file"];
    FileSection currentFileSection = ViewData.Get<FileSection>("currentFileSection");
    User currentUser = (User)ViewData["CurrentUser"];
    bool userCookieRemember = true;
    string rememberMyName = ViewData.GetString("rememberMyName", string.Empty);
    if (string.IsNullOrEmpty(rememberMyName))
    {
        rememberMyName = GetResourceString("Common_AnonymousDisplayName");
        userCookieRemember = false;
    }
    string rememberMyUrl = ViewData.GetString("rememberMyUrl", string.Empty);
    bool isManager = ViewData.GetBool("isManager", false);
    int pageIndex = 0;
    if (!string.IsNullOrEmpty(Html.GetParameterFromRouteDateOrQueryString("pageIndex")))
        pageIndex = int.Parse(Html.GetParameterFromRouteDateOrQueryString("pageIndex"));
    if (comments.TotalRecords == (comments.PageIndex - 1) * comments.PageSize + 1)
        pageIndex = pageIndex - 1;
    int addCommentPageIndex = ViewData.Model.PageIndex;
    if (ViewData.Model.TotalRecords == ViewData.Model.PageSize * addCommentPageIndex)
        addCommentPageIndex = addCommentPageIndex + 1;
%>

<div class="tn-comment-wrap" id="fileCommentsDiv">
  <div class="tn-list-header">
    <div class="tn-text-heading tn-border-bottom tn-border-gray">
      <h4 class="tn-helper-reset"> <%=GetResourceString("Common_Comment") %> <span class="tn-text-note">（<%=Model.TotalRecords %>）</span> </h4>
    </div>
  </div>
  <%if (comments != null && comments.Records.Count > 0)
      {%>
  <%
        if (comments != null)
        {%>
  <ul class="tn-comments tn-helper-reset">
    <% foreach (FileComment comment in comments.Records)
           {
               bool hasPermission = currentUser != null && (isManager || comment.UserID == currentUser.UserID);
               if (comment.IsApproved && comment.AuditingStatus == AuditingStatuses.Success || hasPermission)
               { %>
    <li class="tn-comment-item tn-border-gray tn-border-bottom">
      <div class="tn-comment tn-helper-clearfix">
        <div class="tn-comment-avatar">
          <div class="tn-avatar"> <%=SPBHtmlHelper.Instance().ShowUserAvatar(comment.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small,null)%> </div>
        </div>
        <% if (hasPermission)
                   {%>
        <a class="tn-icon tn-icon-cross tn-helper-right" onclick="if (confirm('<%=GetResourceString("Message_DeleteComment",ApplicationIDs.Instance().File()) %>')) { $('#fileCommentsDiv').parent().load('<%=SPBUrlHelper.Action("DeleteFileComment","ChannelFile",new RouteValueDictionary{{"fileThreadID",file.ThreadID},{"commentPostID",comment.PostID},{"pageIndex",pageIndex}}) %>' )}"> </a>
        <%} %>
        <a name="<%=comment.PostID %>" id="<%=comment.PostID %>"></a>
        <div class="tn-comment-info">
          <div class="tn-commentator">
            <h5>
              <% if (!string.IsNullOrEmpty(comment.TitleUrl))
                               { %>
              <a class="tn-author" href="<%=comment.TitleUrl %>" title="<%=string.Format(GetResourceString("Description_Pattern_ViewUserDomain"), comment.Author)%>"> <%=comment.Author%></a>
              <%}
                               else Response.Write(comment.Author); %>
            </h5>
            <em class="tn-text-note tn-date"> <%=Formatter.FormatFriendlyDate(comment.PostDate)%></em>
            <% if (!comment.IsApproved) Response.Write(GetResourceString("Message_NotCheck", ApplicationIDs.Instance().File())); %>
            &nbsp;
            <% if (!comment.IsApproved && isManager)
                           {%>
            <a href="javascript:;" onclick="setCommentApproveStatus('<%=SPBUrlHelper.Action("SetFileCommentApproveStatus", "ChannelFile", new RouteValueDictionary {{ "threadID", file.ThreadID }, { "postID", comment.PostID }, { "isApproved", true }, { "pageIndex", comments.PageIndex } })%>')"> <%=GetResourceString("Action_PassCheck", ApplicationIDs.Instance().File())%></a>
            <%} %>
            <span class="tn-text-note">
            <% if (CurrentUser != null && comment.UserID != CurrentUser.UserID && CurrentUser != null)
                               { %>
            <a href="javascript:;" onclick="$('#commentBody').focus().attr('value','<%=string.Format("{0}{1}：",GetResourceString("Common_Reply"),comment.Author) %>');$('#parentID').attr('value','<%=comment.PostID %>');"> <%=GetResourceString("Common_Reply")%></a>
            <%} %>
            </span> </div>
          <%if (comment.ParentID > 0)
                      { %>
          <blockquote class="tn-cue-tips tn-bg-gray tn-border-gray">
            <p> <%=GetResourceString("Common_Reply")%> <a class="tn-author" href="<%=SiteUrls.Instance().UserDomainHome(comment.ParentUserID) %>"> <%=comment.ParentAuthor%></a><em class="tn-text-note tn-date"><%=Formatter.FormatDate(comment.ParentPostDate, true)%></em></p>
            <p> <%=comment.ParentBody%></p>
          </blockquote>
          <%} %>
          <p> <%=comment.Body%></p>
        </div>
      </div>
    </li>
    <%}
           }%>
  </ul>
  <div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, comments.TotalRecords, comments.PageSize, comments.PageIndex, 7, SPBUrlHelper.Action("ShowFile", "ChannelFile", new RouteValueDictionary {  { "threadID", file.ThreadID }, { "pageIndex", "{0}" } }))%> </div>
  <%}
      } %>
  <% if (currentFileSection.EnableComments && !(CurrentUser == null && (!SiteSettingsManager.GetSiteSettings().EnableAnonymousPosting || !currentFileSection.EnableAnonymousPosting)))
       {%>
  <%
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            if (messageType == StatusMessageType.Success)
            {
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.Get<string>("StatusMessageContent"), 5000));
            }
            else
            {
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.Get<string>("StatusMessageContent"), 5000));
            }
            TempData["StatusMessageType"] = null;
        } %>
  <form id="fileCommentForm" action="<%=SPBUrlHelper.Action("CreateFileComment","ChannelFile",new RouteValueDictionary{{"threadID",file.ThreadID},{"pageIndex",addCommentPageIndex}}) %>"
    method="post">
    <div class="tn-form tn-label-top">
      <div class="tn-comment-form-wrap tn-bg-gray">
        <div class="tn-comment-form">
          <div class="tn-comment-form tn-emotion-box"> <a name="addCommentArea"></a>
            <%  Html.RenderAction<ChannelController>(n => n.Control_SmileySelector("smiley", "commentBody"));%>
            <div class="tn-comment-text-wrap tn-border-gray tn-form-row-near tn-textarea-wrap">
              <textarea class="tn-comment-text-area" rows="5" cols="60" name="commentBody" id="commentBody"><%=TempData.GetString("commentBody", string.Empty)%></textarea>
              <input type="hidden" id="parentID" name="parentID" value="<%=TempData.GetInt("parentID", 0)%>" />
            </div>
            <div class="tn-form-row tn-text-note"> <%=string.Format(GetResourceString("Description_Pattern_WordCountLimit"), UserDomainConfiguration.Instance().MaxLengthPerReply)%> </div>
          </div>
        </div>
        <% if (CurrentUser == null)
               {%>
        <div class="tn-form-row">
          <label class="tn-form-label"> <%=GetResourceString("Label_CommonName")%><%=GetResourceString("Common_Colon") %></label>
          <input type="text" class="tn-textbox tn-input-long tn-border-gray" name="author"
                    value="<%=rememberMyName %>" id="author" maxlength="30" />
          <em>(<%=GetResourceString("Common_GuestDisplayName")%>)</em>
          <input type="checkbox" <% if (userCookieRemember) Response.Write("checked=\"checked\""); %>
                    id="rememberMe" value="1" name="rememberMe" />
          <label for="rememberMe"> <%=GetResourceString("Description_MemoryMyInfo")%></label>
        </div>
        <% } %>
        <% SiteSettings settings = SiteSettingsManager.GetSiteSettings();
               if (settings.VerifyCodeOption == VerifyCodeOption.Enabled || CurrentUser == null && settings.VerifyCodeOption == VerifyCodeOption.Anonymous)
               {%>
        <div class="tn-form-row tn-form-row-verifycode">
          <label> <%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon")%></label>
          <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode", VerificationCodeDifficultyLevel.Low)%> </div>
        <%} %>
        <div class="tn-form-row tn-form-row-button">
          <label class="tn-form-label"> &nbsp;</label>
          <%=SPBHtmlHelper.Instance().SubmitButton("createComment", GetResourceString("Button_Submit"))%>
          <% if (Request.UrlReferrer != null)
                   {%>
          <%=SPBHtmlHelper.Instance().CancelButton( Request.UrlReferrer.AbsoluteUri)%>
          <%} %>
        </div>
      </div>
    </div>
  </form>
  <%} %>
  <script type="text/javascript">
    
           function setCommentApproveStatus(url)
            {  
             $('#fileCommentsDiv').load(url);
            }
        $(document).ready(function() {
            $("#fileCommentForm").validate({
                rules: {
                    commentBody: { required: true, rangelength: [1, <%=UserDomainConfiguration.Instance().MaxLengthPerReply %>] },
                    verifyCode:{required: true}
                },
                messages: {
                    commentBody: { required: "<%=GetResourceString("Validate_FillInCommentBody") %>", rangelength: "<%=string.Format(GetResourceString("Validate_Pattern_CommentBodyMaxLength"), UserDomainConfiguration.Instance().MaxLengthPerReply)%>" },
                    verifyCode:{required: "<%=GetResourceString("Validate_FillInValidate") %>"}
                }
            });
            $('.nyroModal').nyroModal({
                resizeable: true
            });
           
            $('#fileCommentForm').ajaxForm({
            target: '#fileConnents',
            cache:false,
            beforeSubmit: function() {
                $('#fileCommentForm').block({
                    message: '<%=GetResourceString("Message_Loading")%>'
                });
            },
            success: function() {
                $('#fileCommentForm').unblock();
            }
        });
        }); 
    </script>
</div>
