﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<FileThread>>" %>
<% PagingDataSet<FileThread> fileThreads = ViewData.Model;
   FileThreadSortBy sortBy = ViewData.Get<FileThreadSortBy>("sortBy", FileThreadSortBy.PostDate);
   SortOrder sortOrder = ViewData.Get<SortOrder>("sortOrder", SortOrder.Descending);
   string tagName = ViewData.GetString("tagName", string.Empty);
   int categoryID = ViewData.GetInt("categoryID", -1);
   int applicationid = ApplicationIDs.Instance().File();
%>
<ul class="tn-list tn-helper-reset" id="fileListDiv">
    <% if (fileThreads != null && fileThreads.Records.Count > 0)
       {
           foreach (FileThread fileThread in fileThreads.Records)
           {
               string showFileUrl = SiteUrls.Instance().ShowFile(fileThread.ThreadID);%>
    <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
        <%if (fileThread.UserFeaturedImageAttachmentID > 0)
          {  %>
        <div class="tn-list-item-area-left">
            <a href="<%=SiteUrls.Instance().ShowFile(fileThread.ThreadID)%>">
                <img src="<%=SiteUrls.Instance().FileFeaturedImageUrl(fileThread.UserFeaturedImageAttachmentID, FileFeaturedImageTypes.Title)%>"
                    alt="<%=FileFeaturedImageTypes.Title %>" /></a>
        </div>
        <%} %>
        <div class="tn-list-item-area-main">
            <div class="tn-list-item-row tn-list-item-heading">
                <h5 class="tn-helper-reset">
                    <%=SPBHtmlHelper.Instance().ContentTypeThumbnail(fileThread.FileName, ContentTypeThumbnailSize.Small)%><a
                        href="<%=showFileUrl%>" title="<%=fileThread.Subject%>"><%=StringUtils.Trim(fileThread.Subject,50)%></a>
                    <% if (fileThread.IsEssential)
                       {%>
                    <span title="<%=GetResourceString("Common_Essential") %>" class="tn-icon tn-icon-elite tn-icon-inline">
                    </span>
                    <%} %>
                    <%if (fileThread.SpecialOrder > 0)
                      { %>
                    <span title="<%=GetResourceString("Common_SetTop")%>" class="tn-icon tn-icon-top tn-icon-inline">
                    </span>
                    <%} %>
                </h5>
            </div>
            <div class="tn-list-item-row">
                <%if (fileThread.Price > 0)
                  { %>
                <em class="tn-text-note"><span class="tn-icon tn-icon-coins tn-icon-inline"></span>
                    <%=fileThread.Price%></em>
                <%} %>
                <em class="tn-text-note tn-count">
                    <%=GetResourceString("Label_Size",applicationid)%><%=GetResourceString("Common_Colon")%><%=Formatter.FormatFriendlyFileSize(fileThread.ContentSize)%></em>
                <% if (fileThread.UserTags != null && fileThread.UserTags.Count > 0)
                   {
                       Response.Write(GetResourceString("Common_UserTag") + "：");
                       foreach (string tName in fileThread.UserTags)
                       { %>
                <a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ListFilesBySiteTag(tName)) %>">
                    <%=tName%></a>
                <%}
                   }%>
                <%--if (fileThread.UserTags != null && fileThread.UserTags.Count > 0)
                  { %>
                <em>
                    <%Response.Write(GetResourceString("Common_UserTag") + "：");
                      foreach (string tagName in fileThread.UserTags)
                      {
                          Response.Write(string.Format("<a href='{0}' target='_blank'>{1}</a> ", Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("Search", "ChannelFile", new RouteValueDictionary { { "TagNames", tagName }, { "SiteCategoryID", query.SiteCategoryID }, { "Keyword", query.Keyword }, { "UserID", query.UserID } })), tagName));
                      } %>
                </em>
                <%} --%>
            </div>
            <div class="tn-list-item-row tn-list-item-summary">
                <p class="tn-helper-reset">
                    <%=fileThread.Summary%></p>
            </div>
        </div>
        <div class="tn-list-item-row">
            <cite>
                <%=SPBHtmlHelper.Instance().UserDisplayNameLink(fileThread.OwnerUserID,fileThread.Author,ApplicationIDs.Instance().File()) %>
            </cite><em class="tn-date tn-text-note">
                <%=GetResourceString("Label_PostOf", applicationid)%>
                <%=Formatter.FormatFriendlyDate(fileThread.PostDate)%></em> <cite class="tn-text-note">
                    <%=SPBHtmlHelper.Instance().ShowRating(fileThread.RatingSum, fileThread.TotalRatings)%></cite>
            <%int downLoadCount = sortBy != FileThreadSortBy.StageDownloadCount ? fileThread.DownloadCount : fileThread.StageDownloadCount;%>
            <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Common_Comment") + fileThread.CommentCount, showFileUrl + "#addCommentArea", ButtonSizes.Default, HighlightStyles.Lite, IconTypes.Bubble, TextIconLayout.IconText)%>
            <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Common_Browse") + fileThread.HitTimes, showFileUrl, ButtonSizes.Default, HighlightStyles.Lite, IconTypes.View, TextIconLayout.IconText)%>
            <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Label_Download", applicationid) + downLoadCount, showFileUrl, ButtonSizes.Default, HighlightStyles.Lite, IconTypes.Download, TextIconLayout.IconText)%>
        </div>
    </li>
    <%}
       } %>
</ul>
<div class="tn-pagination tn-helper-align-center">
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, fileThreads.TotalRecords, fileThreads.PageSize, fileThreads.PageIndex, 7, SPBUrlHelper.Action("Control_ListFileThreads", "ChannelFile", new RouteValueDictionary { { "pageSize", fileThreads.PageSize }, { "sortOrder", sortOrder }, { "sortBy", sortBy }, { "categoryID", categoryID }, { "tagName", tagName }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
</div>

<script type="text/javascript">
    function pageIndexChange(url) {
        $('#fileListDiv').parent().load(url);
    }
</script>

