﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<FileThread>>" %>
<%FileThreadSortBy sortBy = ViewData.Get<FileThreadSortBy>("sortBy"); %>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-new-files-main">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"><%=ViewData.GetString("moduleTitle",GetResourceString("Title_FileModule",ApplicationIDs.Instance().File())) %></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <table class="tn-table-grid">
      <tbody>
        <% 
             foreach(FileThread fileThread in Model)
            {%>
        <tr class="tn-table-grid-row">
          <td class="tn-border-gray tn-border-bottom tn-width-icon1"><%=SPBHtmlHelper.Instance().ContentTypeThumbnail(fileThread.FileName, ContentTypeThumbnailSize.Small)%></td>
          <th class="tn-border-gray tn-border-bottom tn-width-auto"><a href="<%=SiteUrls.Instance().ShowFile(fileThread.ThreadID ) %>" title="<%=fileThread.Subject %>"><%=StringUtils.Trim(fileThread.Subject,28)%></a>
            <%if (fileThread.SiteCategory != null)
              { %>
            <a href="<%=SPBUrlHelper.Action("Search", "ChannelFile", new RouteValueDictionary { { "SiteCategoryID", fileThread.SiteCategoryID }})%>" class="tn-text-note">【<%=fileThread.SiteCategory.CategoryName%>】</a>
            <%} %>
          </th>
          <% switch (sortBy)
           {
               case FileThreadSortBy.PostDate:
                   Response.Write("<td class='tn-border-gray tn-border-bottom tn-width-date tn-nowrap'><em class='tn-date tn-text-note'>" + Formatter.FormatDate(fileThread.PostDate) + "</em></td>");
                   break;
               case FileThreadSortBy.StageHitTimes:
                   Response.Write("<td class='tn-border-gray tn-border-bottom tn-width-number tn-nowrap'><em class='tn-count tn-text-note'>" + fileThread.StageHitTimes + "</em></td>");
                   break;
               case FileThreadSortBy.StickyAndPostDate:
                   Response.Write("<td class='tn-border-gray tn-border-bottom tn-width-date tn-nowrap'><em class='tn-date tn-text-note'>" + Formatter.FormatDate(fileThread.PostDate) + "</em></td>");
                   break;             
               default:
                   break;
           } %>
        </tr>
        <%} %>
      </tbody>
    </table>
    <p class="tn-more"><a href="<%=SPBUrlHelper.Action("FileRanks", "ChannelFile", new RouteValueDictionary { { "rankBy", sortBy } })%>"><%=GetResourceString("Action_More")%></a></p>
  </div>
</div>
<div class="tn-blank10"></div>
