﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<FileThread>>" %>
<%int siteCagegoryID = ViewData.GetInt("siteCagegoryID", 0);
  FileThreadSortBy sortBy = ViewData.Get<FileThreadSortBy>("sortBy");
  if (ViewData.Model != null && ViewData.Model.Count > 0)
  { %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-files-rank-block">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%=ViewData.GetString("moduleTitle",GetResourceString("Title_FileModule",ApplicationIDs.Instance().File())) %></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ol class="tn-list tn-list-rank tn-img-sprite">
            <%foreach (FileThread fileThread in Model)
              {%>
            <li><em class="tn-count tn-text-note tn-helper-right">
                <%switch (sortBy)
                  {
                      case FileThreadSortBy.CommentCount:
                          Response.Write(fileThread.CommentCount);
                          break;
                      case FileThreadSortBy.DownloadCount:
                          Response.Write(fileThread.DownloadCount);
                          break;
                      case FileThreadSortBy.HitTimes:
                          Response.Write(fileThread.HitTimes);
                          break;
                      case FileThreadSortBy.PostDate:
                          Response.Write(Formatter.FormatDate(fileThread.PostDate));
                          break;
                      case FileThreadSortBy.StageDownloadCount:
                          Response.Write(fileThread.StageDownloadCount);
                          break;
                      case FileThreadSortBy.StageHitTimes:
                          Response.Write(fileThread.StageHitTimes);
                          break;
                      case FileThreadSortBy.StickyAndPostDate:
                          Response.Write(Formatter.FormatDate(fileThread.PostDate));
                          break;
                      default:
                          Response.Write(fileThread.StageHitTimes);
                          break;
                  } %>
            </em><a title="<%=fileThread.Subject %>" href="<%=SiteUrls.Instance().ShowFile(fileThread.ThreadID) %>">
                <%=StringUtils.Trim(fileThread.Subject.Trim(), 10)%></a> </li>
            <%} %>
        </ol>
        <p class="tn-more">
            <%if (sortBy == FileThreadSortBy.StageDownloadCount)
              {
            %>
            <a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("FileRanks", "ChannelFile", new RouteValueDictionary { { "RankBy", FileThreadSortBy.StageDownloadCount }, { "categoryID", siteCagegoryID }}))%>">
                <%=GetResourceString("Action_More")%></a>
            <%}
              else
              { %>
            <a href="<%=SPBUrlHelper.Action("Search", "ChannelFile", new RouteValueDictionary { { "sortBy", sortBy },{"isEssential",true},{ "SiteCategoryID", siteCagegoryID } })%>">
                <%=GetResourceString("Action_More")%></a>
            <%}
            %>
        </p>
    </div>
</div>
<div class="tn-blank10">
</div>
<%} %>
