﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<FileThread>>" %>
<%User user = ViewData.Get<User>("user"); %>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-other-files">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=GetResourceString("Title_FileUpLoadOthers",ApplicationIDs.Instance().File())%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-list">
      <%foreach (FileThread fileThread in Model)
              {%>
      <li><em class="tn-count tn-text-note tn-helper-right"> <%=fileThread.DownloadCount %></em> <a title="<%=fileThread.Subject %>" href="<%=SiteUrls.Instance().ShowFile(fileThread.ThreadID) %>"> <%=StringUtils.Trim(fileThread.Subject, 15)%></a> </li>
      <%} %>
    </ul>
    <p class="tn-more">
      <% if (ViewData.Model != null && ViewData.Model.Count > 0)
        {%>
      <a  href="<%=SPBUrlHelper.Action("Home", "File", new RouteValueDictionary { { "userDomainName", user.UserName } })%>"><%=GetResourceString("Action_More")%></a>
      <%} %>
    </p>
  </div>
</div>
<div class="tn-blank10"> </div>
