﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<ForumThreadCategory>" %>
<%
    if (TempData["StatusMessageData"] != null)
    {
        StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData");
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
        if (statusMessageData.MessageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',3000);</script>"));
            TempData["StatusMessageData"] = null;
        }
        
   
    }
%>

<form class="nyroModal" id="editSectionForm" method="post" action="<%=SPBUrlHelper.Action("CreateUpdateForumThreadCategory", "ChannelForum", new RouteValueDictionary { { "categoryID", Model.CategoryID }, { "sectionID", Model.SectionID } })%>">
  <%int applicationID = ApplicationIDs.Instance().Forum(); %>
  <div class="tn-form tn-label-right">
    <div class="tn-text-heading tn-border-gray tn-border-bottom">
      <h4>
        <%if (Model.CategoryID > 0) { Response.Write(GetResourceString("Title_EditeForumCategory", applicationID)); } else { Response.Write(GetResourceString("Title_CreateForumCategory",applicationID)); } %>
      </h4>
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"><%=GetResourceString("Label_CategoriesName",applicationID)%><%=GetResourceString("Common_Colon") %></label>
      <input type="text" class="tn-textbox tn-input-medium tn-border-gray" name="categoryName" id="categoryName"
                value="<%=Model.CategoryName %>" />
    </div>
    <div class="tn-form-row tn-textarea-wrap">
      <label class="tn-form-label"> <%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %></label>
      <textarea id="categoryDescription" name="categoryDescription" class="tn-textarea tn-input-long tn-border-gray"
                rows="4" cols="30"><%=Model.CategoryDescription %></textarea>
      <span style="display:none"></span> </div>
    <div class="tn-form-row">
      <label class="tn-form-label"><%=GetResourceString("Label_OrderNum",applicationID)%><%=GetResourceString("Common_Colon") %></label>
      <input  class="tn-textbox tn-input-short tn-border-gray" style="width: 50px" id="displayOrder" name="displayOrder"
                maxlength="256" value="<%=Model.DisplayOrder %>" />
    </div>
    <div class="tn-form-row tn-form-row-button">
      <label class="tn-form-label"> </label>
      <%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_Save"), ButtonSizes.Default, new RouteValueDictionary { { "class", "inputSubmit" } }, null)%> <%=SPBHtmlHelper.Instance().CancelButton(ButtonSizes.Default, new RouteValueDictionary { { "class", "nyroModalClose" } })%> </div>
  </div>
</form>
<script type="text/javascript" rel="forceLoad">
    $(document).ready(function() {
        $("#editSectionForm").validate({
            rules: {
            categoryName: { required: true, maxBlength: 8 },
            categoryDescription: { maxBlength: 100 },
            displayOrder: { required: true, digits: true }
            },
            messages: {
            categoryName: { required: "<%=GetResourceString("Validate_Required", applicationID)%>", maxBlength: "<%=GetResourceString("Validate_CategoryNum", applicationID)%>" },
            categoryDescription: { maxBlength: "<%=GetResourceString("Validate_CategoryDescription", applicationID)%>" },
            displayOrder: { required: "<%=GetResourceString("Validate_PleaseInputOrderNum", applicationID)%>", digits: "<%=GetResourceString("Validate_PleaseInputNum", applicationID)%>" }
            }
        });
        $("#saveButton").click(function() {
            if (!$("#editSectionForm").valid()) {
                return false;
            }
        });
    });
</script>
