﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<Dictionary<ForumSectionGroup, List<ForumSection>>>" %>
<%int appid = ApplicationIDs.Instance().Forum();
  string viewUrl = SPBUrlHelper.Action("Home", "ChannelForum");
%>
<div class="spb-forum-nav">
    <div class="tn-list-header">
        <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
            <span class="tn-helper-right">
                <span class="tn-button tn-button-default">
                    <span class="tn-first-child">
                        <a href="javascript:;" class="tn-button-text" id="EnterSelectModule">
                            <%=GetResourceString("Button_EnterSelectModule",appid)%></a>
                    </span>
                </span>
                <span class="tn-button tn-button-text-icon tn-button-primary">
                    <span class="tn-first-child">
                        <span class="tn-icon tn-icon-topic"></span>
                        <a href="javascript:;" class="tn-button-text" id="sendPosts">
                            <%=GetResourceString("Button_DirectnessSendPosts",appid)%></a>
                    </span>
                </span>
            </span>
            <strong>
                <%=GetResourceString("Title_ModuleNavigation",appid)%></strong></div>
    </div>
    <div class="spb-forum-nav-wrap">
        <ul id="ForumNavigation">
            <%foreach (KeyValuePair<ForumSectionGroup, List<ForumSection>> pair in Model)
              {

                  viewUrl = Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("ShowForumGroup", "ChannelForum", new RouteValueDictionary { { "groupID", pair.Key.GroupID } }));%>
            <li data="{'gid':'<%=pair.Key.GroupID %>','url':'<%=viewUrl %>'}" ondblclick="window.location.href='<%=viewUrl %>'">
                <span class="tn-state-default"><strong>
                    <%=pair.Key.GroupName %></strong>
                    <%if (pair.Value.Count > 0)
                      { %><span class="tn-icon tn-icon-triangle-right"></span>
                    <%} %>
                </span>
                <ul style="display: none">
                    <%foreach (var section in pair.Value)
                      {
                          viewUrl = Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("ShowForumSection", "ChannelForum", new RouteValueDictionary { { "sectionID", section.SectionID } }));
                    %>
                    <li data="{sid:'<%=section.SectionID %>',url:'<%=viewUrl %>'}">
                        <span class="tn-state-default" ondblclick="window.location.href='<%=viewUrl %>'"><strong>
                            <%=section.SectionName %></strong><%if (section.ChildCount > 0)
                                                                { %>
                            <span class="tn-icon tn-icon-triangle-right"></span>
                            <%} %></span>
                        <ul style="display: none">
                            <%foreach (var childsection in section.Childs)
                              {
                                  viewUrl = Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("ShowForumSection", "ChannelForum", new RouteValueDictionary { { "sectionID", section.SectionID } }));%>
                            <li data="{sid:'<%=section.SectionID %>',url:'<%= viewUrl%>'}" ondblclick="window.location.href='<%=viewUrl %>'">
                                <span class="tn-state-default"><strong>
                                    <%=childsection.SectionName%></strong></span></li>
                            <%} %>
                        </ul>
                    </li>
                    <%} %>
                </ul>
                <%} %>
            </li>
        </ul>
    </div>
</div>

<script type="text/javascript">

    $(document).ready(function() {
        $("#ForumNavigation li").click(function() {
            $("#ForumNavigation span.tn-state-active").removeClass("tn-state-active");
            $(this).children("span.tn-state-default").addClass("tn-state-active").end().parent().find("ul").hide().end().end().children("ul").show();
            return false;
        });

        $("#EnterSelectModule").click(function() {
            var $activeGroupItem = $("#ForumNavigation span.tn-state-active").parent();
            if ($activeGroupItem.length > 0) {
                var data = eval("(" + $activeGroupItem.attr("data") + ")");
                window.location.href = data.url;
            }
            else
                alert('<%=GetResourceString("Message_SelectModule",appid)%>');
            return false;
        });

        $("#sendPosts").click(function() {
            var $activeSectionItem = $("#ForumNavigation span.tn-state-active").parent();
            var sectiondata = eval("(" + $activeSectionItem.attr("data") + ")");
            if ($activeSectionItem.length > 0 && sectiondata.sid > 0) {
                window.location.href = '<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("NewForumThread","ChannelForum"))%>?sectionID=' + sectiondata.sid;
            }
            else
                alert('<%=GetResourceString("Message_SelectChildModule",appid)%>');
            return false;
        });
    });



</script>

