﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% ForumThread forumThread = ViewData.Get<ForumThread>("forumThread", null);
   if (forumThread == null)
   {
       throw new SPBException(ExceptionTypes.Instance().PostNotFound());
   }
   int forumsApplication = ApplicationIDs.Instance().Forum();
   int replyUserID = Html.GetParameterFromRouteDateOrQueryString<int>("replyUserID");
   bool isDesc = Html.GetParameterFromRouteDateOrQueryString<bool>("isDesc");
   bool hasEditPermission = ((CurrentUser != null && CurrentUser.UserID == forumThread.UserID) || (CurrentUser != null && ForumPermission.Validate(forumThread.ForumSection, CurrentUser, PermissionItemKeys.Instance().EditForumPost())));
   string threadBody = forumThread.GetBody(hasEditPermission);
   int postCount = 0;
   string signature = string.Empty;
   ForumUserData userData = ForumUserDatas.GetUserData(forumThread.UserID, false);
   if (userData != null)
   {
       postCount = userData.PostCount;
       signature = userData.Signature;
   }
   bool isShowReply = ViewData.GetBool("isShowReply", false);
%>
<div class="tn-widget-content spb-post-floor spb-master-floor">
    <a name="<%=forumThread.PostID %>"></a>
    <a name="f_0"></a>
    <table>
        <tbody>
            <tr>
                <td class="tn-widget-content spb-post-side" rowspan="2">
                    <span class="tn-user-name">
                        <a href="<%=SiteUrls.Instance().UserChannelHome(forumThread.UserID,ApplicationIDs.Instance().Forum()) %>">
                            <strong>
                                <%=forumThread.Author %></strong></a>
                        <% if (forumThread.AuthorUser != null && forumThread.AuthorUser.IsOnline)
                           { %>
                        <img alt="<%=GetResourceString("Action_OnLine",forumsApplication)%>" src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/user_IsOnline.gif")%>" />
                        <% }
                           else
                           { %>
                        <img alt="<%=GetResourceString("Action_Offline",forumsApplication)%>" src="<%=WebUtils.FullPath(Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/user_IsOffline.gif"))%>" />
                        <%} %>
                    </span>
                    <div class="tn-avatar-medium" value="<%=forumThread.UserID %>">
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(forumThread.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Card)%>
                    </div>
                    <% if (forumThread.AuthorUser != null)
                       {
                    %>
                    <div class="tn-info-part">
                        <% string roleIcons = SPBHtmlHelper.Instance().ShowUserRoleIcons(forumThread.AuthorUser);
                           if (!string.IsNullOrEmpty(roleIcons))
                           { %>
                        <dl>
                            <dt>
                                <%=GetResourceString("Label_PersonUserTitle",ApplicationIDs.Instance().User())%><%=GetResourceString("Common_Colon") %></dt>
                            <dd>
                                <span class="spb-user-type">
                                    <%=roleIcons %></span></dd>
                        </dl>
                        <%} %>
                        <dl>
                            <dt>
                                <%=GetResourceString("Label_Rank")%><%=GetResourceString("Common_Colon") %></dt>
                            <dd>
                                <span class="spb-user-type">
                                    <%=SPBHtmlHelper.Instance().ShowUserRankIcons(forumThread.AuthorUser) %>
                                </span>
                            </dd>
                        </dl>
                        <% if (forumThread.AuthorUser.UserType == UserTypes.PersonUser && (forumThread.AuthorUser as PersonUser) != null)
                           { %>
                        <dl>
                            <dt></dt>
                            <dd>
                                <span class="spb-user-type">
                                    <%=Formatter.FormatArea((forumThread.AuthorUser as PersonUser).NowAreaCode, true)%>
                                </span>
                            </dd>
                        </dl>
                        <%} %>
                        <dl>
                            <dt>
                                <%=GetResourceString("Label_SendTopic",forumsApplication)%><%=GetResourceString("Common_Colon") %></dt><dd><%=postCount%></dd>
                        </dl>
                        <dl>
                            <dt>
                                <%=GetResourceString("Action_RegistrationDate",forumsApplication)%><%=GetResourceString("Common_Colon") %></dt><dd><%=Formatter.FormatDate(forumThread.AuthorUser.DateCreated) %></dd>
                        </dl>
                    </div>
                    <%} %>
                </td>
                <td class="spb-post-content">
                    <div class="spb-post-meta tn-border-gray tn-border-bottom">
                        <span class="spb-post-through">
                            <a class="tn-icon tn-icon-escalator" id="Escalator" title="楼层直达"></a>
                            <input type="text" name="" id="floorNum" class="tn-textbox tn-border-gray" /></span>
                        <span class="spb-post-number tn-helper-right"><strong>
                            <%=GetResourceString("Label_FloorHost",forumsApplication)%></strong></span>
                        <em class="tn-date">
                            <%=GetResourceString("Label_AppearOf",forumsApplication)%><%=GetResourceString("Common_Colon") %><%=Formatter.FormatDate(forumThread.PostDate,true) %></em>
                        <% if (replyUserID == forumThread.UserID)
                               Response.Write(SPBHtmlHelper.Instance().ActionLink(GetResourceString("Action_SeeAll", forumsApplication), SiteUrls.Instance().ShowForumThread(forumThread.ThreadID, null, isDesc)));
                           else if (replyUserID <= 0)
                               Response.Write(SPBHtmlHelper.Instance().ActionLink(GetResourceString("Action_SeeFloorHost", forumsApplication), SiteUrls.Instance().ShowForumThread(forumThread.ThreadID, forumThread.UserID, isDesc)));
                           Response.Write(SPBHtmlHelper.Instance().ActionLink(isDesc ? GetResourceString("Action_ASC", forumsApplication) : GetResourceString("Action_DESC", forumsApplication), SiteUrls.Instance().ShowForumThread(forumThread.ThreadID, replyUserID, !isDesc)));
                        %>
                        <span class="spb-stamp">
                            <%=StampManager.Instance().GetStamp(forumThread.StampID,false) %></span>
                    </div>
                    <%  bool isShowBody = true;
                        if (CurrentUser == null && forumThread.IsHidden)
                        {
                            isShowBody = false;%>
                    <div class="tn-widget">
                        <div class="tn-cue-highlight tn-corner-all tn-message-box">
                            <span class="tn-helper-left">
                                <span class="tn-icon tn-icon-exclamation"></span>
                            </span>
                            <div class="tn-helper-flowfix">
                                您需要<a class="tn-action-text" href="<%=SiteUrls.Instance().Login(true) %>">登录</a>回复后才可以查看！</div>
                        </div>
                    </div>
                    <%}
                        else if (!hasEditPermission && CurrentUser != null && forumThread.IsHidden && !ForumPosts.IsReplyer(forumThread.ThreadID,
                        CurrentUser.UserID))
                        {
                            isShowBody = false;%>
                    <div class="tn-widget">
                        <div class="tn-cue-highlight tn-corner-all tn-message-box">
                            <span class="tn-helper-left">
                                <span class="tn-icon tn-icon-exclamation"></span>
                            </span>
                            <div class="tn-helper-flowfix">
                                <%=GetResourceString("SetsHidden",forumsApplication)%><a href="#quickReply"><%=GetResourceString("Title_Revert",forumsApplication)%></a>
                                <%=GetResourceString("SetsHidden2",forumsApplication)%></div>
                        </div>
                    </div>
                    <%}
                        else if (!hasEditPermission && forumThread.Price > 0)
                        {
                            isShowBody = false; %>
                    <div class="tn-widget">
                        <div class="tn-cue-highlight tn-corner-all tn-message-box">
                            <span class="tn-helper-left">
                                <span class="tn-icon tn-icon-exclamation"></span>
                            </span>
                            <div class="tn-helper-flowfix">
                                <%if (CurrentUser == null)
                                  {
                                      //提示匿名用户需要登录才能浏览
                                      Response.Write(string.Format(GetResourceString("Description_Pattern_UserLimit", forumsApplication), forumThread.Price));
                                  }
                                  else if (ForumThreads.IsExistExchangeThread(CurrentUser, forumThread.ThreadID) || hasEditPermission)
                                  {
                                      isShowBody = true;
                                      //提示管理者或购买者
                                      if (hasEditPermission)
                                          Response.Write(string.Format(GetResourceString("Title_HaveAdminLimit", forumsApplication), forumThread.Price.ToString()));
                                      else
                                          Response.Write(string.Format(GetResourceString("Title_ShoppingIntegral", forumsApplication), forumThread.Price.ToString()));
                                  }
                                  else
                                  {%>
                                <%=string.Format(GetResourceString("Description_Pattern_UserLimitSee", forumsApplication), forumThread.Price)%><a
                                    href="<%=Url.Action("ExchangeThreadAction", "ChannelForum", new { threadID = forumThread.ThreadID }) %>"
                                    onclick="if(!confirm('<%=string.Format(GetResourceString("Message_ConfirmShopping", forumsApplication), forumThread.Price)%>')){return false;}"><%=GetResourceString("Action_Shopping",forumsApplication)%></a>
                                <%}%>
                            </div>
                        </div>
                    </div>
                    <%}
                        if (isShowBody)
                        { %>
                    <div class="tn-detail-text">
                        <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001002110002", new RouteValueDictionary { { "class", "spb-ad-flag" } })%>
                        <%=threadBody %>
                    </div>
                    <%
                        if (CurrentUser != null && forumThread.HasAttachment && ForumPermission.Validate(forumThread.ForumSection, CurrentUser, PermissionItemKeys.Instance().DownloadForumAttachment()))
                        {
                            List<Attachment> attachments = ForumAttachmentManager.Instance().GetAttachmentsByAssociateID(forumThread.PostID, hasEditPermission);
                            if (attachments != null && attachments.Count(n => !n.IsImage) > 0)
                            {  %>
                    <div class="tn-annex-fix">
                        <div class="tn-text-heading tn-border-bottom tn-border-gray">
                            <h4>
                                <%=GetResourceString("Label_Attachment")%></h4>
                            <span class="tn-icon tn-icon-paper-clip"></span>
                        </div>
                        <ul class="tn-helper-reset tn-list tn-annex-list">
                            <%foreach (Attachment attachment in attachments)
                              {
                                  ForumAttachment forumAttachment = attachment as ForumAttachment;
                                  if (attachment.IsImage)
                                      continue;%>
                            <li class="tn-annex-item">
                                <span class="tn-annex-icon">
                                    <%=SPBHtmlHelper.Instance().ContentTypeThumbnail(attachment.FileName, ContentTypeThumbnailSize.Small)%></span>
                                <%if (forumAttachment != null && forumAttachment.IsHidden && !ForumPosts.IsReplyer(forumThread.ThreadID, CurrentUser != null ? CurrentUser.UserID : 0))
                                  {
                                      Response.Write(string.Format("{0}(需要回复才可下载)", attachment.FriendlyFileName));
                                  }
                                  else if (attachment.Price > 0
                                        && !ForumAttachmentManager.Instance().IsPayOut(attachment.AttachmentID, CurrentUser.UserID)
                                        && !hasEditPermission)
                                  {%>
                                <% if (CurrentUser == null)
                                       Response.Write(attachment.FriendlyFileName);
                                   else
                                   {%>
                                <a href="<%=Url.Action("ExchangeAttachmentAction", "ChannelForum", new { attachmentID = attachment.AttachmentID }) %>"
                                    onclick="if(!confirm('<%=string.Format(GetResourceString("Message_ConfirmShopping", forumsApplication), attachment.Price)%>')){return false;}"
                                    target="_self">
                                    <%=attachment.FriendlyFileName%></a>
                                <%} %>
                                <em class="tn-count tn-text-note">（<%=attachment.Friendlylength%>）</em>
                                <%=GetResourceString("Label_NeedIntegral",forumsApplication)%><%=GetResourceString("Common_Colon") %><%=attachment.Price%>，
                                <% if (CurrentUser == null)
                                   {%>
                                <%=string.Format(GetResourceString("Label_Pattern_NotLogin", forumsApplication), SiteUrls.Instance().Login(true), GetResourceString("Action_Login"))%>
                                <% 
                                    }
                                   else
                                   {  %>
                                <a href="<%=Url.Action("ExchangeAttachmentAction", "ChannelForum", new { attachmentID = attachment.AttachmentID }) %>"
                                    onclick="if(!confirm('<%=string.Format(GetResourceString("Message_ConfirmShopping", forumsApplication), attachment.Price)%>')){return false;}"
                                    target="_self">[<%=GetResourceString("Action_Buy",forumsApplication)%>]</a>
                                <%}
                                  }
                                  else
                                  {%>
                                <a href="<%=SiteUrls.Instance().DownloadForumAttachment(attachment.AttachmentID) %>"
                                    target="_blank">
                                    <%=attachment.FriendlyFileName%></a><em class="tn-count tn-text-note">（<%=attachment.Friendlylength%>）</em>
                                <%if (attachment.Price > 0)
                                  {
                                      if (ForumAttachmentManager.Instance().IsPayOut(attachment.AttachmentID, CurrentUser.UserID))
                                      {%>
                                <%=string.Format(GetResourceString("Description_Pattern_DirectnessDownload", forumsApplication), attachment.Price)%>
                                <%}
                                      else
                                      {%>
                                <%=string.Format(GetResourceString("Description_Pattern_AdminLimitDownload", forumsApplication), attachment.Price)%>
                                <%}
                                  }
                                  }%>
                            </li>
                            <%} %>
                        </ul>
                    </div>
                    <%} %>
                    <%} %>
                    <% if (forumThread.Tags != null && forumThread.Tags.Count > 0)
                       {%>
                    <div class="tn-info-part tn-tags">
                        <dl>
                            <dt>
                                <%=GetResourceString("Common_UserTag")%><%=GetResourceString("Common_Colon") %></dt>
                            <%
                                foreach (string tagName in forumThread.Tags)
                                {
                            %>
                            <dd>
                                <a target="_blank" href="<%=SearchConfiguration.Instance().SearchTypeSettingss[ForumSearchTypeSettings.CODE].GetSearchAtionFullUrl(SPBUrlHelper.Action("Search","ChannelForum",new RouteValueDictionary{{"tagName",WebUtils.UrlEncode(tagName)}})) %>">
                                    <%=tagName%></a></dd>
                            <%}%>
                        </dl>
                    </div>
                    <%}%>
                    <%} %>
                </td>
            </tr>
            <tr>
                <td class="spb-post-content">
                    <% if (forumThread.IsUseSignature && !string.IsNullOrEmpty(signature))
                       { %>
                    <div class="spb-sign tn-border-gray tn-border-top">
                        <span class="tn-icon tn-icon-pen"></span>
                        <%=signature %></div>
                    <%} %>
                </td>
            </tr>
            <tr>
                <td class="tn-widget-content spb-post-side">
                    <div class="tn-info-part">
                        <dl>
                            <dt>IP:</dt>
                            <dd>
                                <%=SPBHtmlHelper.Instance().ShowPostIPAddress(forumThread.UserHostAddress)%></dd>
                        </dl>
                    </div>
                </td>
                <td class="spb-post-content">
                    <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001002110003", new RouteValueDictionary { { "class", "spb-ad-topic" } })%>
                    <div class="tn-actions tn-border-gray tn-border-top">
                        <span class="tn-helper-right">
                            <% if (CurrentUser != null) Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Button_Report"), SiteUrls.Instance().NewImpeachReport(), IconTypes.Alert, TextIconLayout.IconText, new RouteValueDictionary { { "class", "nyroModal" } }, null));%>
                            <%=SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_GotoTop",forumsApplication), "javascript:;", null, TextIconLayout.TextOnly, new RouteValueDictionary { { "onclick", "scrollTo(0,0);" } }, null)%>
                        </span>
                        <% if (CurrentUser != null)
                           {
                               if (isShowReply)
                               {
                                   //回复
                                   Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Common_Reply"), SPBUrlHelper.Action("NewForumPost", "ChannelForum", new RouteValueDictionary { { "parentID", forumThread.PostID } }), IconTypes.Bubble, TextIconLayout.IconText, new RouteValueDictionary { { "name", "quickReplyButton" }, { "class", "{author:'" + forumThread.Author + "',postID:'" + forumThread.PostID + "',number:'" + GetResourceString("Label_FloorHost", forumsApplication) + "'}" } }, null));
                                   //引用
                                   Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_Quote", forumsApplication), SPBUrlHelper.Action("NewForumPost", "ChannelForum", new RouteValueDictionary { { "parentID", forumThread.PostID }, { "quote", true } }), IconTypes.QuotesBefore));
                               }
                           }
                           else
                           {
                               //回复
                               Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Common_Reply"), SiteUrls.Instance().Login(true), IconTypes.Bubble, TextIconLayout.IconText, new RouteValueDictionary { { "name", "quickReplyButton" } }, null));
                               //引用
                               Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_Quote", forumsApplication), SiteUrls.Instance().Login(true), IconTypes.QuotesBefore));
                           }

                           if (CurrentUser != null)
                           {
                               if (CurrentUser.UserType != UserTypes.CompanyUser)
                                   Response.Write(SPBHtmlHelper.Instance().ActionLink("sharelink", GetResourceString("Common_Share"), SiteUrls.Instance().ShareInModal(false, Request.RawUrl, HtmlUtils.TrimHtml(forumThread.Subject, 20), HtmlUtils.TrimHtml(forumThread.Body, 140), string.Empty, ApplicationIDs.Instance().Forum(), forumThread.UserID, forumThread.Author), IconTypes.Share, TextIconLayout.IconText, new RouteValueDictionary { { "class", "nyroModal" } }, null));
                           }
                           else
                               Response.Write(SPBHtmlHelper.Instance().ActionLink("sharelink", GetResourceString("Common_Share"), SiteUrls.Instance().Login(true), IconTypes.Share, TextIconLayout.IconText, null, null));
                           if (hasEditPermission)
                           {
                               Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_Edit"), SPBUrlHelper.Action("EditForumThread", "ChannelForum", new RouteValueDictionary { { "threadID", forumThread.ThreadID } }), IconTypes.Write));
                               Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_Delete"), SPBUrlHelper.Action("DeleteForumThread", "ChannelForum", new RouteValueDictionary { { "threadID", forumThread.ThreadID } }), IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "if (!confirm('" + GetResourceString("Message_ConfirmDeleteThread", forumsApplication) + "')) return false;" } }, null));
                           }
                        %>
                    </div>
                </td>
            </tr>
            <tr class="spb-post-space">
                <td class="tn-widget-content spb-post-side tn-bg-light">
                </td>
                <td class="tn-widget-content spb-post-content tn-bg-light">
                </td>
            </tr>
        </tbody>
    </table>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("#Escalator").click(function() {
            if ($("#floorNum").val().length > 0) {
                window.location.href = '<%=SPBUrlHelper.Action("ForumElevator","ChannelForum",new RouteValueDictionary{{"threadID",forumThread.ThreadID}}) %>&floor=' + $('#floorNum').val();
            }
        });

    });
</script>

