﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl< IList<ForumThread>>" %>
<% int applicationId = ApplicationIDs.Instance().Club();
   if (Model != null && Model.Count > 0)
   {%>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-club-topics-block">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=GetResourceString("Title_ClubSubject", applicationId)%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-list">
      <%
                int clubID = 0;
                Club ownerClub = new Club();
                foreach (ForumThread thread in Model)
                {
                    clubID = OwnerID2GroupIDDictionary.Instance(PresentAreaIDs.Instance().ClubDomain()).GetOwnerID(thread.GroupID);
                    ownerClub = Clubs.GetClub(clubID, false);
                    if (ownerClub == null)
                        continue;
            %>
      <li><cite class="tn-helper-right tn-secondary-text"> <%=SPBHtmlHelper.Instance().UserDisplayNameLink(thread.UserID,thread.Author) %> </cite><a class="tn-secondary-text tn-category" href="<%=SiteUrls.Instance().ClubDomainHome(ownerClub.ClubID) %>" target="_blank">【<%=ownerClub.ClubName%>】</a><a target="_blank" href="<%=SiteUrls.Instance().ShowForumThreadInClub(ownerClub.DomainName,thread.ThreadID) %>" title="<%=StringUtils.Trim(thread.Subject, 200)%>"> <%=StringUtils.Trim(thread.Subject, 35)%></a> </li>
      <%} %>
    </ul>
  </div>
</div>
<%} %>
