﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ForumPost>>" %>
<spb:Script runat="server" ID="nyroModal" Src="~/Utility/jquery/plugin/jquery.nyroModal-1.6.2.min.js"
    SetExpireDays="30" />
<%
    PagingDataSet<ForumPost> pds = ViewData.Model;
    if (pds == null)
        throw new SPBException(ExceptionTypes.Instance().UnknownError());
    int appid = ApplicationIDs.Instance().Forum();
%>
<%
    StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData");
    if (TempData["StatusMessageData"] != null)
    {
        SPBHtmlHelper.Instance().StatusMessage(statusMessageData.MessageType, statusMessageData.MessageContent, 2000, false);
        TempData["StatusMessageData"] = null;
    }
%>
<%
    AuditingStatusesForDisplay auditingStatusesForDisplay = ViewData.Get<AuditingStatusesForDisplay>("auditingStatusesForDisplay");
    int pageIndex = ViewData.GetInt("pageIndex");
    string forumSectionSselect = Html.GetParameterFromRouteDateOrQueryString("forumSectionSselect");
    string KeyWords = Html.GetParameterFromRouteDateOrQueryString("KeyWords");
    string SelectStatuses = Html.GetParameterFromRouteDateOrQueryString("SelectStatuses");
    string autoID = Html.GetParameterFromRouteDateOrQueryString("autoID"); 
%>
<div id="listForumPosts">
    <form id="approveForumPostsForm" method="post">
    <div class="tn-list-header">
        <div class="tn-toolbar-area tn-helper-clearfix">
            <input name="checkAllCheckBox" id="checkAllCheckBox" type="checkbox" value="" class="tn-checkbox"
                onclick="checkAll(this,'postIDCheckBox')" />
            <label for="checkAllCheckBox">
                <%=GetResourceString("Label_SelectAllOrNo") %></label>
            <%=SPBHtmlHelper.Instance().LinkButton("batchApprove", GetResourceString("Common_PassAudit"), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Accept, TextIconLayout.IconText, new RouteValueDictionary { { "title", "审核通过选中的帖子" } }, null)%>
            <%=SPBHtmlHelper.Instance().LinkButton("batchNoApprove", GetResourceString("Common_PassNoAudit"), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText, new RouteValueDictionary { { "title", "不审核通过选中的帖子" } }, null)%>
            <%=SPBHtmlHelper.Instance().LinkButton("batchDelete", GetResourceString("Action_Delete"), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Stop, TextIconLayout.IconText, new RouteValueDictionary { { "title", "删除选中的帖子" } }, null)%>
        </div>
    </div>
    <table class="tn-table-grid">
        <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom tn-text-note">
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_Subject")%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_Module",appid)%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_Author")%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_AppearTime", appid)%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_Actions")%>
            </th>
        </tr>
        <%
            int number = 0;
            foreach (var forumPost in pds.Records)
            {
                number++;
                ForumSection forumSection = ForumSections.GetSection(forumPost.SectionID, false);
                if (forumSection == null)
                    continue;
        %>
        <tr class="tn-table-grid-row tn-border-gray tn-border-bottom">
            <td class="tn-border-gray tn-border-bottom tn-width-check">
                <input name="postIDCheckBox" id="postIDCheckBox-<%=forumPost.PostID %>" type="checkbox"
                    value="<%=forumPost.PostID %>" class="tn-checkbox" />
            </td>
            <td class="tn-border-gray tn-border-bottom">
                <a href="<%=SPBUrlHelper.Action("ShowForumPost","ChannelForum",new RouteValueDictionary{{"postID",forumPost.PostID}}) %>"
                    class="nyroModal">
                    <%=forumPost.Subject %></a>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <a href="<%=SPBUrlHelper.Action("ShowForumSection", "ChannelForum", new RouteValueDictionary { { "sectionID", forumPost.SectionID } })%>">
                    <%=forumSection.SectionName %></a>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=SPBHtmlHelper.Instance().UserDisplayNameLink(forumPost.UserID, forumPost.Author, UserDomainSpecialAppIDs.Instance().Home())%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <em class="tn-count tn-text-note">
                    <%=Formatter.FormatDate(forumPost.PostDate,true) %></em>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                <%=SPBHtmlHelper.Instance().LinkButton("search", GetResourceString("Label_Searchauto", appid), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "href", SPBUrlHelper.Action("ManageForumPosts", "ChannelForum", new RouteValueDictionary { { "autoID", forumPost.UserID }, { "auditingStatusesForDisplay", auditingStatusesForDisplay}}) }, { "title", string.Format("搜索{0}的帖子", forumPost.Author) } }, null)%>
            </td>
        </tr>
        <%
}
        %>
    </table>
    </form>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, pds.TotalRecords, pds.PageSize, pds.PageIndex, 11, null) %>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $("#batchApprove").click(function () {
            $('#approveForumPostsForm').attr("action", '<%=SPBUrlHelper.Action("SetForumAuditingStatus", "ChannelForum", new RouteValueDictionary { { "auditingStatuses", AuditingStatusesForDisplay.Success },{ "auditingStatusesForDisplay", auditingStatusesForDisplay }, { "pageIndex", pageIndex },{ "forumSectionSselect", forumSectionSselect }, { "KeyWords", KeyWords },{"autoID",autoID} })%>');
            $('#approveForumPostsForm').submit();
        });
        $("#batchNoApprove").click(function () {
            $('#approveForumPostsForm').attr("action", '<%=SPBUrlHelper.Action("SetForumAuditingStatus", "ChannelForum", new RouteValueDictionary { {"auditingStatuses",AuditingStatusesForDisplay.Fail}, { "auditingStatusesForDisplay", auditingStatusesForDisplay }, { "pageIndex", pageIndex },{ "forumSectionSselect", forumSectionSselect }, { "KeyWords", KeyWords },{"autoID",autoID}})%>');
            $('#approveForumPostsForm').submit();
        });
        $("#batchDelete").click(function () {
            $('#approveForumPostsForm').attr("action", '<%=SPBUrlHelper.Action("DeleteForumPosts", "ChannelForum", new RouteValueDictionary { { "auditingStatusesForDisplay", auditingStatusesForDisplay }, { "pageIndex", pageIndex },{ "forumSectionSselect", forumSectionSselect }, { "KeyWords", KeyWords },{"autoID",autoID}})%>');
            $('#approveForumPostsForm').submit();
        });

    });
</script>
