﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<ForumSection>>" %>
<%int listID = ViewData.GetInt("listID", 0);
  int appid = ApplicationIDs.Instance().Forum();
  int mode = ViewData.GetInt("Mode", (int)BrowseMode.detail);%>
<table class="tn-table-grid" id="forumSection_<%=mode %>_<%=listID%>">
    <tbody>
        <tr class="tn-table-grid-row">
            <%if (Model != null && Model.Count > 0)
              {
                  int i = 1;
                  foreach (var forumSection in Model)
                  {
                      if (mode == (int)BrowseMode.detail)
                      {%>
            <td class="tn-border-gray tn-border-top">
                <div class="tn-helper-clearfix">
                    <div class="spb-forum-icon">
                        <%if (!string.IsNullOrEmpty(forumSection.LogoUrl))
                          {%>
                        <a href="<%=SPBUrlHelper.Action("ShowForumSection","ChannelForum",new RouteValueDictionary{{"sectionID",forumSection.SectionID}}) %>">
                            <img src="<%=SiteUrls.Instance().ForumSectionLogoUrl(forumSection) %>" alt="" /></a>
                        <%}
                          else
                          { %>
                        <a href="<%=SPBUrlHelper.Action("ShowForumSection","ChannelForum",new RouteValueDictionary{{"sectionID",forumSection.SectionID}}) %>">
                            <span class="tn-icon tn-icon-big <%if (forumSection.TodayPostCount > 0) Response.Write("tn-icon-forum-new"); else Response.Write("tn-icon-forum-normal"); %>">
                            </span>
                        </a>
                        <%} %>
                    </div>
                    <div class="spb-forum-info">
                        <h4 class="tn-helper-reset tn-text-heading">
                            <a href="<%=SPBUrlHelper.Action("ShowForumSection","ChannelForum",new RouteValueDictionary{{"sectionID",forumSection.SectionID}}) %>">
                                <%=forumSection.SectionName%></a></h4>
                        <em>今日：<%if (forumSection.TodayPostCount > 0)
                                 { %><strong><a href="<%=SPBUrlHelper.Action("ShowForumSection","ChannelForum",new RouteValueDictionary{{"sectionID",forumSection.SectionID},{"scopes",1}}) %>">
                                     <%=forumSection.TodayPostCount%></a></strong><%}
                                 else Response.Write("0"); %></em>
                        <p>
                            <%=StringUtils.Trim(forumSection.Description, 50)%></p>
                    </div>
                </div>
            </td>
            <td class="tn-border-gray tn-border-top tn-nowrap spb-forum-stats">
                <em>主题：<%=forumSection.CumulateThreadCount%></em><br>
                <em>帖子：<%=forumSection.CumulatePostCount%></em> </td>
            <td class="tn-border-gray tn-border-top tn-nowrap spb-forum-last">
                <%if (forumSection.MostRecentPostAuthorID > 0)
                  { %>
                <cite>
                    <a href="<%=SPBUrlHelper.Action("ShowForumThread","ChannelForum",new RouteValueDictionary{{"threadID",forumSection.MostRecentThreadID}}) %>"
                        title="<%=HtmlUtils.StripForPreview(forumSection.MostRecentPostSubject)%>">
                        <%=StringUtils.Trim(forumSection.MostRecentPostSubject, 10)%></a></cite>
                <%=SPBHtmlHelper.Instance().UserDisplayNameLink(forumSection.MostRecentPostAuthorID, forumSection.MostRecentPostAuthor, UserDomainSpecialAppIDs.Instance().Home())%>
                <em class="tn-text-note tn-date">
                    <%= Formatter.FormatDate(forumSection.MostRecentPostDate, false)%></em>
                <%}%>
            </td>
            <%if (i < Model.Count)
              { %>
        </tr>
        <tr class="tn-table-grid-row">
            <%}
                      }
                      else
                      {%>
            <td class="tn-border-gray tn-border-top" name="mediumItems_<%=listID %>">
                <div class="tn-helper-clearfix">
                    <div class="spb-forum-icon">
                        <%if (!string.IsNullOrEmpty(forumSection.LogoUrl))
                          {%>
                        <a href="<%=SPBUrlHelper.Action("ShowForumSection","ChannelForum",new RouteValueDictionary{{"sectionID",forumSection.SectionID}}) %>">
                            <img src="<%=SiteUrls.Instance().ForumSectionLogoUrl(forumSection) %>" alt="" /></a>
                        <%}
                          else
                          { %>
                        <a href="<%=SPBUrlHelper.Action("ShowForumSection","ChannelForum",new RouteValueDictionary{{"sectionID",forumSection.SectionID}}) %>">
                            <span class="tn-icon tn-icon-big <%if (forumSection.TodayPostCount > 0) Response.Write("tn-icon-forum-new"); else Response.Write("tn-icon-forum-normal"); %>">
                            </span>
                        </a>
                        <%} %>
                    </div>
                    <div class="spb-forum-info">
                        <h4 class="tn-helper-reset tn-text-heading">
                            <a href="<%=SPBUrlHelper.Action("ShowForumSection","ChannelForum",new RouteValueDictionary{{"sectionID",forumSection.SectionID}}) %>">
                                <%=forumSection.SectionName%></a></h4>
                        <em>今日：<%if (forumSection.TodayPostCount > 0)
                                 { %><strong><a href="<%=SPBUrlHelper.Action("ShowForumSection","ChannelForum",new RouteValueDictionary{{"sectionID",forumSection.SectionID},{"scopes",1}}) %>"><%=forumSection.TodayPostCount%></strong></a><%}
                                 else Response.Write("0"); %></em>
                        <p>
                            <em>主题：<%=forumSection.CumulateThreadCount%></em><em>帖子：<%=forumSection.CumulatePostCount%></em></p>
                        <p>
                            <a href="<%=SPBUrlHelper.Action("ShowForumThread","ChannelForum",new RouteValueDictionary{{"threadID",forumSection.MostRecentThreadID}}) %>"
                                title="<%=HtmlUtils.StripForPreview(forumSection.MostRecentPostSubject)%>">
                                <%=HtmlUtils.TrimHtml(forumSection.MostRecentPostSubject, 10)%></a></p>
                    </div>
                </div>
            </td>
            <%if (i % 3 == 0)
              { %>
        </tr>
        <tr class="tn-table-grid-row">
            <%}
              i++;
                      }
                  }
                  if (mode == (int)BrowseMode.medium)
                  {
                      if (i - 1 > 3)
                      {
                          if (i > 3 && i % 3 == 0)
                              i = (i % 3) + 1;
                          else
                              i = i % 3;
                      }
                      else
                          i = 3 - (i - 1);
                      for (int j = 0; j < i; j++)
                      {
                          Response.Write("<td class=\"tn-border-gray tn-border-top\"></td>");
                      }
                  }%>
            <%} %>
        </tr>
    </tbody>
</table>
