﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ForumThread>>" %>
<%int applicationID = ApplicationIDs.Instance().Forum();
  int sortBy = ViewData.GetInt("SortBy", (int)ForumThreadSortBy.PostDate);
  bool? isEssential = ViewData.GetBool("isEssential");
  if (!isEssential.Value) isEssential = null;%>
<table class="tn-table-grid" id="listFourms_<%=sortBy %>">
    <tbody>
        <tr class="tn-table-grid-header">
            <td class="tn-border-gray tn-border-bottom" colspan="2">
                <input type="checkbox" name="isEssential_<%=sortBy %>" id="isEssential_<%=sortBy %>"
                    class="tn-checkbox" value="<%=isEssential %>" <%if(isEssential.HasValue && isEssential.Value) Response.Write("checked=\"checked\"");%> />
                <label for="isEssential_<%=sortBy %>">
                    <%=GetResourceString("Action_Essential",applicationID)%></label>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_Author")%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Common_Reply")%>/
                <%=GetResourceString("Common_Browse")%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_LastRepliedDate", applicationID)%>
            </td>
        </tr>
        <%string iconClass = string.Empty;
          foreach (var forumThread in Model.Records)
          {%>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom spb-topic-icon">
                <a title="<%=GetResourceString("Action_Blank",applicationID)%>" href="<%=SiteUrls.Instance().ShowForumThread(forumThread.ThreadID)%>">
                    <span class="tn-icon tn-icon-big tn-icon-topic-normal" title="普通主题"></span>
                </a>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-auto">
                <% if (forumThread.ForumSection != null)
                   { %>
                <a class="tn-category" href="<%=SiteUrls.Instance().ShowForumSection(forumThread.ForumSection.SectionID) %>">
                    【<%=forumThread.ForumSection.SectionName%>】</a>
                <%} %>
                <a class="tn-text-heading" href="<%=SiteUrls.Instance().ShowForumThread(forumThread.ThreadID)%>">
                    <%=forumThread.Subject %></a>
                <%if (forumThread.IsSticky)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Top, GetResourceString("Action_Top", applicationID), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  if (forumThread.IsEssential)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Elite, GetResourceString("Action_Essential", applicationID), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  if (forumThread.Price > 0)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Coins, string.Format(GetResourceString("Action_Takes", applicationID), forumThread.Price), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  if (forumThread.IsHot)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Fire, GetResourceString("Action_HotTopic"), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  if (forumThread.IsLocked)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Lock, GetResourceString("Action_Lock"), new RouteValueDictionary { { "class", " tn-icon-inline" } }));%>
                <%=SPBHtmlHelper.Instance().ContentTypeThumbnail(forumThread.AttachmentFilename,ContentTypeThumbnailSize.Small)%>
                <%if (forumThread.ReplyCount > ForumConfiguration.Instance().PostsPerPage)
                  { %>
                <span class="spb-topic-pages tn-text-note">
                    <%=SPBHtmlHelper.Instance().ShowForumThreadPager(forumThread,null) %></span>
                <%} %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                <cite>
                    <%=SPBHtmlHelper.Instance().UserDisplayNameLink(forumThread.UserID,forumThread.Author,applicationID) %>
                </cite><em class="tn-text-note">
                    <%=Formatter.FormatFriendlyDate(forumThread.PostDate) %></em> </td>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                <cite>
                    <a href="<%=SiteUrls.Instance().ShowForumThread(forumThread.ThreadID)%>" title="回复数">
                        <%=forumThread.ReplyCount %></a></cite> <em class="tn-text-note">
                            <%=forumThread.HitTimes %></em> </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                <%if (forumThread.MostRecentPostID > 0)
                  { %>
                <cite>
                    <%if (forumThread.MostRecentPostAuthorID > 0)
                      { %>
                    <a href="<%=SiteUrls.Instance().UserChannelHome(forumThread.MostRecentPostAuthorID,ApplicationIDs.Instance().Forum()) %>"
                        title="<%=forumThread.MostRecentPostAuthor %>" target="_blank">
                        <%=forumThread.MostRecentPostAuthor%></a>
                    <%}
                      else
                          Response.Write(forumThread.MostRecentPostAuthor); %>
                </cite>
                <a href="<%=SiteUrls.Instance().ShowForumThreadGotoLastPost(forumThread.ThreadID, forumThread.MostRecentPostID)%>"
                    title="<%=forumThread.LastRepliedDate %>"><em class="tn-text-note">
                        <%=Formatter.FormatFriendlyDate(forumThread.LastRepliedDate) %></em></a>
                <%} %>
            </td>
        </tr>
        <%} %>
    </tbody>
</table>
<div class="tn-pagination tn-helper-align-center">
    <%if (Model.TotalRecords > Model.PageSize)
      {%>
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListForumThreads", "ChannelForum", new RouteValueDictionary { { "sortBy", (int)sortBy }, { "isEssential", isEssential }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
    <%} %>
    <div class="tn-page-results tn-text-note">
        <%if (Model.PageIndex > 1)
          {
              int count = Model.PageSize * Model.PageIndex - 1;
              Response.Write(count + "-" + (count - Model.PageSize));
          }%>共
        <%=Model.TotalRecords %>个</div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('#isEssential_<%=sortBy %>').click(function() {
            if ($(this).attr("checked"))
                $('#listFourms_<%=sortBy %>').parent().load('<%=SPBUrlHelper.Action("Control_ListForumThreads", "ChannelForum", new RouteValueDictionary { { "sortBy", (int)sortBy }, { "isEssential", true }}) %>');
            else
                $('#listFourms_<%=sortBy %>').parent().load('<%=SPBUrlHelper.Action("Control_ListForumThreads", "ChannelForum", new RouteValueDictionary { { "sortBy", (int)sortBy }}) %>');
        });
    });
    function pageIndexChange(url) {
        $('#listFourms_<%=sortBy %>').parent().load(url);
    }
</script>

