﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<ForumThread>>" %>
<%int sortBy = ViewData.GetInt("SortBy", (int)ForumThreadSortBy.PostDate);
  bool isEssential = Html.GetParameterFromRouteDateOrQueryString<bool>("IsEssential");
%>

<div class="tn-box tn-widget tn-widget-content tn-corner-all">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=ViewData.GetString("ModelTitle", string.Empty)%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-list">
      <%foreach (var item in Model)
              {
            %>
      <li>
        <%if (isEssential)
                  {%>
        <cite class="tn-helper-right tn-secondary-text"> <%=SPBHtmlHelper.Instance().UserDisplayNameLink(item.UserID,item.Author,UserDomainSpecialAppIDs.Instance().Home()) %> </cite>
        <%}
                  else if (sortBy == (int)ForumThreadSortBy.HitTimes)
                  {%>
        <em class="tn-count tn-text-note tn-helper-right"> <%=item.HitTimes%></em>
        <% }
                  else if (sortBy == (int)ForumThreadSortBy.PostDate)
                  {%>
        <em class="tn-text-note tn-date tn-helper-right"> <%=Formatter.FormatFriendlyDate(item.PostDate,false)%></em>
        <%}
                  else if (sortBy == (int)ForumThreadSortBy.ReplyCount)
                  {%>
        <em class="tn-text-note tn-date tn-helper-right"> <%=item.ReplyCount%></em>
        <%}%>
        <a href="<%=SPBUrlHelper.Action("ShowForumThread","ChannelForum",new RouteValueDictionary{{"threadID",item.ThreadID}}) %>"> <%=StringUtils.Trim(item.Subject,16) %></a> </li>
      <%
                } %>
    </ul>
    <p class="tn-more"><a href="<%=SPBUrlHelper.Action("ListForumThreads","ChannelForum",new RouteValueDictionary{{"sortBy",sortBy}}) %>"> <%=GetResourceString("Action_More")%></a></p>
  </div>
</div>
<div class="tn-blank10"> </div>
