﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<ManageThreadAttachmentsModel>" %>
<% if (Model.Attachments != null && Model.Attachments.Count > 0)
   { %>
<div id="attachmentListDiv_<%=Model.IsImage %>">
    <div class="<% if (Model.IsImage) Response.Write("spb-pic-wrapper"); else Response.Write("spb-attachment-wrapper"); %>">
        <ul class="tn-photo-list tn-widget tn-helper-reset tn-helper-clearfix">
            <%
                SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
                foreach (var attachment in Model.Attachments)
                {
                    if (Model.IsImage != attachment.IsImage)
                        continue;
                    string renderHtml;
                    if (attachment.IsImage)
                    {
                        if (siteSettings.UseUBBRenderInlinedImage)
                        {
                            renderHtml = string.Format("[attachimg]{0}[/attachimg]", attachment.AttachmentID);
                        }
                        else
                        {
                            if (siteSettings.InlinedImageWidth > 0 && attachment.Width > siteSettings.InlinedImageWidth)
                                renderHtml = string.Format("<a href='{0}' target='_blank'><img src='{0}' alt='{1}' border='0' width='{2}' /></a>", Model.GetAttachmentUrl(attachment.AttachmentID), attachment.FriendlyFileName, siteSettings.InlinedImageWidth);
                            else if (siteSettings.InlinedImageHeight > 0 && attachment.Height > siteSettings.InlinedImageHeight)
                                renderHtml = string.Format("<a href='{0}' target='_blank'><img src='{0}' alt='{1}' border='0' height='{2}' /></a>", Model.GetAttachmentUrl(attachment.AttachmentID), attachment.FriendlyFileName, siteSettings.InlinedImageHeight);
                            else
                                renderHtml = string.Format("<a href='{0}' target='_blank'><img src='{0}' alt='{1}' border='0' /></a>", Model.GetAttachmentUrl(attachment.AttachmentID), attachment.FriendlyFileName);
                        }
                    }
                    else if (attachment.ContentType.IndexOf("application/x-shockwave-flash") > -1)
                    {
                        renderHtml = string.Format("<object width=\"100\" height=\"100\" data=\"{0}\" type=\"application/x-shockwave-flash\"><param name=\"src\" value=\"{0}\" /></object>", Model.GetAttachmentUrl(attachment.AttachmentID));
                    }
                    else if (attachment.ContentType.IndexOf("video/quicktime") > -1)
                    {
                        renderHtml = string.Format("<object classid=\"clsid:02bf25d5-8c17-4b23-bc80-d3488abddc6b\" width=\"100\" height=\"100\" codebase=\"http://www.apple.com/qtactivex/qtplugin.cab#version=6,0,2,0\">"
                        + "<param name=\"src\" value=\"{0}\" /><embed type=\"video/quicktime\" width=\"100\" height=\"100\" src=\"{0}\"></embed>"
                        + "</object>", Model.GetAttachmentUrl(attachment.AttachmentID));
                    }
                    else if (attachment.ContentType.IndexOf("video/x-ms-wmv") > -1)
                    {
                        renderHtml = string.Format("<object classid=\"clsid:6bf52a52-394a-11d3-b153-00c04f79faa6\" width=\"100\" height=\"100\" codebase=\"http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=5,1,52,701\">"
                            + "<param name=\"url\" value=\"{0}\" /><embed type=\"application/x-mplayer2\" width=\"100\" height=\"100\" src=\"{0}\"></embed></object>", Model.GetAttachmentUrl(attachment.AttachmentID));
                    }
                    else if (attachment.ContentType.IndexOf("audio/x-pn-realaudio-plugin") > -1)
                    {
                        renderHtml = string.Format("<object classid=\"clsid:cfcdaa03-8be4-11cf-b84b-0020afbbccfa\" width=\"100\" height=\"100\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0\">"
                            + "<param name=\"src\" value=\"{0}\" /><embed type=\"audio/x-pn-realaudio-plugin\" width=\"100\" height=\"100\" src=\"{0}\"></embed>"
                            + "</object>", Model.GetAttachmentUrl(attachment.AttachmentID));
                    }
                    else
                    {
                        renderHtml = string.Format("[attach]{0}[/attach]", attachment.AttachmentID);
                    }
                    renderHtml = WebUtils.HtmlEncode(renderHtml);          
            %>
            <li class="tn-photo-item">
                <input type="hidden" name="renderHtml" value="<%=renderHtml %>" />
                <span class="tn-check-widget tn-widget-content tn-border-gray"><span class="tn-icon tn-icon-accept">
                </span></span>
                <p class="tn-photo-wrap tn-widget-content tn-border-gray">
                    <a href="javascript:;">
                        <%=Model.ShowAttachmentThumbnail(attachment, ContentTypeThumbnailSize.Large)%><span></span></a></p>
                <p class="tn-text-heading">
                    <a href="<%=Model.GetAttachmentUrl(attachment.AttachmentID) %>" target="_blank">
                        <%=attachment.FriendlyFileName %></a>
                </p>
                <% if (!attachment.IsImage)
                   {
                       if (attachment.Price > 0)
                       { %>
                <p>
                    售价：<%=attachment.Price %>
                </p>
                <%} %>
                <% 
                    ForumAttachment forumAttachment = attachment as ForumAttachment;
                    if (forumAttachment != null && forumAttachment.IsHidden)
                    {                   
                %>
                <p>
                    回复可见
                </p>
                <%}
                   } %>
                <p>
                    <span class="tn-action"><a href="javascript:;"
                            class="tn-action-text" onclick="if (confirm('<%=string.Format(GetResourceString("Message_Pattern_ConfirmDeleteAttachment"),attachment.FriendlyFileName) %>')) {$('#attachmentListDiv_<%=Model.IsImage %>').parent().load('<%=Model.DeleteAttachmentUrl(attachment.AttachmentID,Model.IsImage) %>',{random:'bsie6'});return false;}">
                            <%=GetResourceString("Action_Delete")%></a> </span>
                </p>
            </li>
            <%}%>
        </ul>
    </div>
    <div class="tn-form tn-label-right tn-border-gray tn-border-top">
        <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label">
            </label>
            <%=SPBHtmlHelper.Instance().Button("insertHtmlEditorButton_"+Model.IsImage,GetResourceString("Action_InsertEditor") , ButtonSizes.Default, HighlightStyles.Primary, null,new RouteValueDictionary {{"class","dialogClose"}})%>
            <%=SPBHtmlHelper.Instance().CloseButton(new RouteValueDictionary {{"class","dialogClose"} })%>
        </div>
    </div>
</div>
<%} %>
<%string selectItemTip = GetResourceString("Message_PleaseClickToInsertThePictureSelected");
  if (!Model.IsImage)
      selectItemTip = GetResourceString("Message_PleaseClickToInsertTheAttachmentSelected"); %>

<script type="text/javascript">
    $(document).ready(function() {
        $("#insertHtmlEditorButton_<%=Model.IsImage %>", $("#attachmentListDiv_<%=Model.IsImage %>")).click(function() {
            var $selectedItems = $("li.tn-photo-item", $("#attachmentListDiv_<%=Model.IsImage %>")).filter(".tn-selected");
            if ($selectedItems.length == 0) {
                alert("<%=selectItemTip %>");
                return false;
            }
            $selectedItems.find("input[type='hidden'][name='renderHtml']").each(function() {
                InsertContentToHtmlEditor($(this).attr("value") + '<br/>');
                $(this).siblings(".tn-photo-wrap").click();
            });
        });
    });
</script>

