﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% 
    ChannelForumSubMenu? subMenu = null;
    if (ViewData["ChannelForumSubMenu"] != null)
        subMenu = (ChannelForumSubMenu)ViewData["ChannelForumSubMenu"];
    

    int applicationID = ApplicationIDs.Instance().Forum();
    
%>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner">
        <ul class="spb-nav2 tn-helper-reset tn-helper-clearfix sf-menu sf-js-enabled sf-shadow">
            <li <% if(subMenu!=null && subMenu== ChannelForumSubMenu.ForumHome) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\"");%>>
                <a href="<%=SPBUrlHelper.Action("Home","ChannelForum")%>"><span>
                    <%= GetResourceString("Title_ForumIndex", applicationID)%></span></a></li>

            <%if (CurrentUser != null)
              { %>
            <li class="spb-nav-item"><a href="<%=SiteUrls.Instance().UserChannelHome(CurrentUser.UserID,ApplicationIDs.Instance().Forum()) %>">
                <span>
                    <%=GetResourceString("Action_MyForum", applicationID)%></span></a></li>
            <%}
              else
              { %>
            <li class="spb-nav-item"><a href="<%=SiteUrls.Instance().Login(true) %>"><span>
                <%=GetResourceString("Action_MyForum", applicationID)%></span></a></li>
            <%} %>
        </ul>
    </div>
</div>
<div class="spb-header-bottom">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <div class="tn-shortcut">
            <% if (CurrentUser != null && (CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator || ForumSections.IsModeratorOfAnySection(CurrentUser.UserName)))
               {%>
            <span class="tn-action"><a href="<%=SPBUrlHelper.Action("ManageForumThreads","ChannelForum",new RouteValueDictionary{{"auditingStatusesForDisplay",AuditingStatusesForDisplay.Fail}})%>">
                <%=GetResourceString("Action_ForumManage", applicationID)%>
            </a></span>
            <%} %>
            <span class="tn-action"><a href="<%=SPBUrlHelper.Action("Control_ShowForumNavigation","ChannelForum") %>"
                class="tn-action-text nyroModal">
                <%= GetResourceString("Action_ForumDescription", applicationID)%></a></span>
        </div>
        <spb:BreadCrumb ID="BreadCrumb" runat="server" />
    </div>
</div>
