﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% 
    UploadAttachmentSettings settings = ViewData.Get<UploadAttachmentSettings>("UploadAttachmentSettings", new UploadAttachmentSettings());    
%>
<script type="text/javascript">
    var swfu_<%=settings.IsImage %>;
    //需要设置的参数：
    //upload_url：处理上传文件的Url，
    //file_types：能够上传的文件类型，例如："*.jpg;*.gif" 用英文分号隔开，
    //file_queue_limit：允许排队的文件总数，0为不限制 ，
    //file_size_limit：单个文件大小的限制 参数接收一个单位，有效的单位有B、KB、MB、GB，默认单位是KB。例如: 2147483648 B, 2097152, 2097152KB, 2048 MB, 2 GB
    //attributes：需要传给后端进行处理的控件ID，例如："categoryID;tagName"
    $(document).ready(function() {
        var settings = {
            flash_url: '<%=settings.FlashUrl %>',
            upload_url: '<%=settings.UploadUrl %>',
            post_params: {
                "currentUserID": "<%=EncryptManager.EncryptTokenForInviteFriend(CurrentUser.UserID.ToString()) %>"
            },
            file_size_limit: '<%=settings.FileSizeLimit %>',
            file_types: '<%=settings.FileTypes %>',
            file_types_description: "All Files",
            file_queue_limit: '<%=settings.FileQueryLimit %>',
            custom_settings: {
                progressTarget: "fsUploadProgress_<%=settings.IsImage %>",
                cancelButtonId: "btnCancel_<%=settings.IsImage %>"
            },
            debug: false,

            // Button settings
            button_image_url: '<%=WebUtils.ResolveUrl("~/Themes/Shared/Styles/Images/upload-button.png") %>', // Relative to the Flash file
            button_width: "140",
            button_height: "40",
            button_placeholder_id: "spanButtonPlaceHolder_<%=settings.IsImage %>",
            button_text: '<span class="theFont"><%=GetResourceString("Common_Browse")%></span>',
            button_text_style: ".theFont { font-size: 14px; font-weight: bold; text-align: center; color:#333333; }",
            button_text_left_padding: 0,
            button_text_top_padding: 10,

            // The event handler functions are defined in handlers.js
            file_queued_handler: fileQueued,
            file_queue_error_handler: fileQueueError,
            file_dialog_complete_handler: fileDialogComplete,
            upload_start_handler: uploadStart,
            upload_progress_handler: uploadProgress,
            upload_error_handler: uploadError,
            upload_success_handler:  function (file, serverData) {
                    var serverData = eval('(' + serverData + ')');
                    if (!serverData.ok && serverData.message) {
                        var progress = new FileProgress(file, this.customSettings.progressTarget);
                        progress.setError();
                        progress.toggleCancel(false);
                        progress.setStatus(serverData.message);
                        return false;
                    }
                },
            upload_complete_handler: uploadComplete,
            queue_complete_handler: <%=settings.QueueCompleteCallback %>	// Queue plugin event
        };
        swfu_<%=settings.IsImage %> = new SWFUpload(settings);
    });
    var attributes = '<%=settings.Attributes %>';
    
    function uploadAttachmentsStart() {
        var attributesArray = attributes.split(";");

        $(attributesArray).each(function() {
            if (this == "ynPublic" || this == "onlyAllowRegisteredUserDownload") {

                swfu_<%=settings.IsImage %>.addPostParam($("[name='" + this + "']").attr("name"), $("[name='" + this + "']").attr("checked"));
            }
            else {
                swfu_<%=settings.IsImage %>.addPostParam($("[name='" + this + "']").attr("name"), $("[name='" + this + "']").attr("value"));
            }
        });
        <% if(!settings.IsImage){ %>
        swfu_<%=settings.IsImage %>.addPostParam('isHidden', $("input[name='isHidden']:checked").attr("value"));
        swfu_<%=settings.IsImage %>.addPostParam('price',  $("[name='price']").attr("value"));
        <%} %>
        swfu_<%=settings.IsImage %>.addPostParam('associateID', '<%=settings.AssociateID %>');
        swfu_<%=settings.IsImage %>.addPostParam('ownerID', '<%=settings.OwnerID %>');
        swfu_<%=settings.IsImage %>.startUpload();
    }
 
             $("#UploadAttachmentForm").validate({
                rules: {
                  price:{digits:true ,max : 9999}
                },
                messages: {
                price:{digits:"售价必须为正整数！",max:"售价最大值为9999<%=GetResourceString("Label_TradePoint", ApplicationIDs.Instance().User())%>！"}
                }
            });
</script>
<div class="spb-upload-files" id="flashUploadFiles_<%=settings.IsImage %>">
    <div class="spb-upload-wrapper">
        <div class="spb-upload-actions">
            <span id="spanButtonPlaceHolder_<%=settings.IsImage %>"></span><a class="spb-upload-button"
                type="button" onclick="swfu_<%=settings.IsImage %>.cancelQueue();">
                <%=GetResourceString("Button_ClearList",ApplicationIDs.Instance().File()) %></a>
        </div>
        <div class="spb-upload-fieldset tn-border-gray tn-border-bottom" id="fsUploadProgress_<%=settings.IsImage %>">
            <span class="spb-upload-legend">
                <%=GetResourceString("Description_UploadList",ApplicationIDs.Instance().File())%></span>
        </div>
        <% if (!settings.IsImage)
           { %>
        <form id="UploadAttachmentForm" class="tn-helper-reset">
        <div class="tn-form tn-label-right">
            <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
                附加选项
            </h4>
            <div class="tn-form-row">
                <label class="tn-form-label">
                    仅回复可下载：</label>
                <div class="tn-input-multiple">
                    <input type="radio" class="tn-radio-buttun" id="ishidden_true" value="true" name="isHidden" />
                    <label for="ishidden_true">
                        是</label>
                    <input type="radio" class="tn-radio-buttun" checked="checked" id="ishidden_false"
                        value="false" name="isHidden" />
                    <label for="ishidden_false">
                        否</label>
                </div>
            </div>
            <div class="tn-form-row">
                <label class="tn-form-label">
                    单个售价：</label>
                <input type="text" class="tn-textbox tn-input-short tn-border-gray" name="price" />
            </div>
        </div>
        </form>
        <%} %>
        <div class="spb-upload-actions">
            <%=SPBHtmlHelper.Instance().Button(string.Empty,GetResourceString("Button_Upload") , ButtonSizes.Large, HighlightStyles.Primary, null, new RouteValueDictionary { { "onclick", "uploadAttachmentsStart();" } })%>
            <%=SPBHtmlHelper.Instance().Button(string.Empty, GetResourceString("Action_ReturnList"), ButtonSizes.Large, HighlightStyles.Secondary, null, new RouteValueDictionary { { "onclick", settings.QueueCompleteCallback + "()" } })%>
        </div>
    </div>
</div>
