﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<spb:Script runat="server" ID="bgiframe" Src="~/Utility/jquery/plugin/jquery.bgiframe.min.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="JqueryFormJs" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="artDialog" Src="~/Utility/jquery/plugin/jquery.artDialog.min-3.0.5.js"
    SetExpireDays="30" />
<%
    int notReadMessageCount = 0;
    int unsettledInvitationTotalCount = 0;
    int notReadNoticeCount = 0;
    int applicationID = ViewData.GetInt("applicationID", 0);
    int SecondaryID = ViewData.GetInt("SecondaryID", 0);
    if (CurrentUser != null)
    {
        //获取未读消息
        notReadMessageCount = PrivateMessages.GetNoReadCount(CurrentUser.UserID);

        //获取未处理邀请字典集合
        Dictionary<int, int> unsettledInvitationCounts = Invitations.GetUnsettledCounts(CurrentUser.UserID);

        foreach (KeyValuePair<int, int> pair in unsettledInvitationCounts)
        {
            unsettledInvitationTotalCount += pair.Value;
        }
        notReadNoticeCount = InstationNotices.GetNoReadCount(CurrentUser.UserID);
    }
    int totalCount = notReadMessageCount + unsettledInvitationTotalCount + notReadNoticeCount;
    IList<OwnerNavigation> userNavigations = null;
    int currentUserPresentAreaID = PresentAreaIDs.Instance().UserDomain();
    if (CurrentUser != null && CurrentUser.UserType == UserTypes.CompanyUser)
        currentUserPresentAreaID = PresentAreaIDs.Instance().CompanyUserDomain();
    if (CurrentUser != null)
        userNavigations = Navigations.GetOwnerNavigations(currentUserPresentAreaID, CurrentUser.UserID, true);
    IList<Navigation> list = Navigations.GetDefaultNavgitions(PresentAreaIDs.Instance().Channel(), false);
    
%>
<div class="spb-top-menubar">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <div class="spb-user-menu">
            <% 
                if (CurrentUser != null)
                { %>
            <ul class="sf-menu sf-js-enabled sf-shadow">
                <% if (CurrentUser.UserType == UserTypes.PersonUser)
                   { %>
                <li><a href="<%=Globals.GetFullUrlInMainSite(WebUtils.ResolveUrl("~/Help/Home.html")) %>"
                    target="_blank">
                    <%=GetResourceString("Action_Help")%></a></li>
                <% } %>
                <li><a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("Logout","ChannelUser")) %>">
                    <%=GetResourceString("Action_Logout")%></a></li>
                <li class="tn-msg-bubble-position"><a id="messageCenter" href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ListMessageInBox(CurrentUser.UserName)) %>"
                    class="sf-with-ul">
                    <%=GetResourceString("Navigation_UserDomain_MessageCenter")%></a>
                    <% if (totalCount > 0)
                       { %>
                    <span class="tn-msg-bubble"><span class="tn-img-sprite tn-msg-bubble-left"></span><span
                        class="tn-img-sprite tn-msg-bubble-center">
                        <%=totalCount %></span> <span class="tn-img-sprite tn-msg-bubble-right"></span>
                    </span>
                    <%} %>
                    <ul class="tn-widget tn-widget-content tn-bg-light tn-corner-all" style="visibility: hidden;
                        display: none;">
                        <li><a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ListMessageInBox(CurrentUser.UserName)) %>">
                            <%=GetResourceString("Action_PrivateMessage")%>
                            <% if (notReadMessageCount > 0)
                                   Response.Write(string.Format("({0})", notReadMessageCount)); %>
                        </a></li>
                        <% if (CurrentUser.UserType == UserTypes.PersonUser)
                           { %>
                        <li><a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ListInvitationInBox(CurrentUser.UserName)) %>">
                            <%=GetResourceString("Action_Invitation")%>
                            <% if (unsettledInvitationTotalCount > 0)
                                   Response.Write(string.Format("({0})", unsettledInvitationTotalCount)); %>
                        </a></li>
                        <%} %>
                        <li><a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ListNoticeRecords(CurrentUser.UserName)) %>">
                            <%=GetResourceString("Action_Notice")%>
                            <% if (notReadNoticeCount > 0)
                                   Response.Write(string.Format("({0})", notReadNoticeCount)); %>
                        </a></li>
                    </ul>
                </li>
                <li class="tn-msg-bubble-position"><a class="sf-with-ul" href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().UserDomainHome(CurrentUser)) %>">
                    <%=CurrentUser.DisplayName %></a>
                    <ul class="tn-widget tn-widget-content tn-bg-light tn-corner-all" style="display: none;
                        visibility: hidden;">
                        <li><a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().UserDomainHome(CurrentUser.UserName))%>">
                            <% if (CurrentUser.UserType == UserTypes.PersonUser) Response.Write(GetResourceString("Navigation_UserDomain_MyHome")); else Response.Write(GetResourceString("Navigation_UserDomain_Home"));%></a></li>
                        <li><a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().UserSettingsHome(CurrentUser.UserName)) %>">
                            <%=GetResourceString("Action_SettingsHome")%></a></li>
                        <%  if (CurrentUser.IsInRoles(SiteSettingsManager.GetSiteSettings().RoleNamesForEnterControlPanel))
                            { %>
                        <li class="spb-separator tn-border-light tn-border-bottom"></li>
                        <% if (CurrentUser.IsAdministrator)
                           { %>
                        <li><a href="<%=SiteUrls.Instance().ModifyHome() %>">
                            <%=GetResourceString("Title_SiteModifyHome") %>
                        </a></li>
                        <%} %>
                        <li><a target="_blank" href="<%=SiteUrls.Instance().ManageHome() %>">
                            <%=GetResourceString("Navigation_Manage_Home")%></a></li>
                        <%}
                            if (userNavigations != null)
                            { %>
                        <li class="spb-separator tn-border-light tn-border-bottom"></li>
                        <%  foreach (OwnerNavigation navigation in userNavigations)
                            {
                                if (!navigation.IsVisible(true))
                                    continue;                                    
                        %>
                        <li><a href="<%=navigation.GetUserNavigationUrl(CurrentUser.UserName) %>">
                            <%=string.Format(GetResourceString("Navigation_Pattern_MyNavigation"), navigation.GetMultilingualNavigationName(CurrentUserLanguage))%></a></li>
                        <%}
                            } %>
                    </ul>
                </li>
            </ul>
            <%}
                else
                { %>
            <ul id="AnonymousPanel" class="sf-menu sf-js-enabled sf-shadow">
                <li><a href="<%=Globals.GetFullUrlInMainSite(WebUtils.ResolveUrl("~/Help/Home.html")) %>"
                    target="_blank">
                    <%=GetResourceString("Action_Help")%></a></li>
                <%if (SiteSettingsManager.GetSiteSettings().RegistrationMode == RegistrationModes.EnableAll)
                  { %>
                <li><a href="<%=SiteUrls.Instance().UserRegister() %>">
                    <%=GetResourceString("Action_Register")%></a></li>
                <%} %>
                <li><a href="<%=SiteUrls.Instance().LoginInModal() %>" id="loginInModalButton">
                    <%=GetResourceString("Action_Login")%></a></li>
            </ul>
            <%} %>
        </div>
    </div>
</div>
<div class="spb-branding-area">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <div id="spb-logo">
            <a href="<%=SiteUrls.Instance().Home() %>">
                <%=Globals.SiteName %></a></div>
        <div class="spb-search-box tn-helper-clearfix">
            <div class="tn-search-box tn-widget-content tn-border-light">
                <form method="post" id="globalFullTextSearchForm">
                <% var searTypeSettingss = SearchConfiguration.Instance().SearchTypeSettingss.Settingss;
                   SearchTypeSettingsBase selectedSearTypeSettings = searTypeSettingss.SingleOrDefault(n => n.ApplicationID == applicationID && n.IsShowInChannelSearch);
                   if (selectedSearTypeSettings == null)
                       selectedSearTypeSettings = searTypeSettingss.SingleOrDefault(n => n.ApplicationID == ApplicationIDs.Instance().User());
                %>
                <span class="tn-search-button tn-bg-light">
                    <button type="submit" id="GolbalSearchButton">
                        <%=GetResourceString("Button_Search")%></button>
                </span>
                <input name="keyword" id="globalFullTextSearchKeyword" class="tn-search-input tn-border-light tn-border-lr"
                    type="text" />
                <% if (selectedSearTypeSettings != null)
                   { %>
                <%=SPBHtmlHelper.Instance().Button("fullTextSearchTypes", selectedSearTypeSettings.GetMultilingualSearchName(CurrentUserLanguage), ButtonSizes.Default, HighlightStyles.Lite, IconTypes.TriangleDown, TextIconLayout.MenuButton, new RouteValueDictionary { { "menu", "#fullTextSearchTypeControl" }, { "url", selectedSearTypeSettings.GetSearchAtionFullUrl() } }, null)%>
                <%}
                   else
                   { %>
                <%=SPBHtmlHelper.Instance().Button("fullTextSearchTypes", string.Empty, ButtonSizes.Default, HighlightStyles.Lite, IconTypes.TriangleDown, TextIconLayout.MenuButton, new RouteValueDictionary { { "menu", "#fullTextSearchTypeControl" }, { "url", string.Empty } }, null)%>
                <%} %>
                <div id="fullTextSearchTypeControl" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
                    <ul>
                        <% foreach (var searTypeSettings in searTypeSettingss)
                           {
                               if (!Applications.IsEnabled(searTypeSettings.ApplicationID))
                                   continue;
                               if (!searTypeSettings.IsShowInChannelSearch)
                                   continue;
                        %>
                        <li class="tn-menu-item"><a class="tn-menu-text" href="javascript:;" url="<%=searTypeSettings.GetSearchAtionFullUrl() %>">
                            <%=searTypeSettings.GetMultilingualSearchName(CurrentUserLanguage) %></a></li>
                        <%} %>
                    </ul>
                </div>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="spb-nav1-area">
    <div class="tn-wrapper-inner">
        <ul class="spb-nav1 tn-helper-reset tn-helper-clearfix">
            <% 
                
                Response.Write(string.Format("<li class=\"spb-nav-item {1}\"><a href=\"{0}\"><span>{2}</span></a></li>", SiteUrls.Instance().Home(), "spb-nav-home", GetResourceString("Navigation_SiteHome")));
                foreach (var navigation in list)
                {
                    if (navigation.IsEnabled)
                        Response.Write(string.Format("<li class=\"spb-nav-item {2}\"><a target=\"{0}\" href=\"{1}\"><span>{3}</span></a></li>", navigation.NavigationTarget, navigation.GetNavigationUrl(), (navigation.IsCurrent(applicationID, SecondaryID) && applicationID > 0) ? " tn-text-note tn-selected" : "", navigation.GetMultilingualNavigationName(CurrentUserLanguage)));
                }
            %>
        </ul>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('ul.sf-menu').superfish();
        $('#loginInModalButton').dialog({
                id: 'loginDialog',
                title: '登录',
                width: 300             
            });

        $("#fullTextSearchTypes").menuButton();
        $("#fullTextSearchTypeControl").find("li.tn-menu-item").click(function() {
            var $a = $(this).find("a.tn-menu-text");
            $("#fullTextSearchTypes").attr("url", $a.attr("url")).text($a.text());
            $("#fullTextSearchTypeControl").hide();
        });

        $("#globalFullTextSearchForm").submit(function() {
            $('#globalFullTextSearchForm').attr("action", $("#fullTextSearchTypes").attr("url"));
        });
       if(<%=totalCount %> > 0)
        newMessageHint('<%=GetResourceString("Description_NewMessage")%>');
    });
</script>

