﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<PersonUser>>" %>
<%
    PersonUsersSortBy sortBy = (PersonUsersSortBy)ViewData.GetInt("sortBy", (int)PersonUsersSortBy.CreateDate);
    int applicationID = ApplicationIDs.Instance().User();
%>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-members-highest-block">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    
    <h3 class="tn-helper-reset">
      <%if (sortBy == PersonUsersSortBy.Rank)
           Response.Write("等级最高");
           else
             Response.Write("最新加入");
           %>
    </h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-avatar-list tn-helper-reset">
      <%if (Model != null && Model.Count > 0)
              {
                  foreach (PersonUser user in Model)
                  {%>
      <li class="tn-avatar-item">
        <div class="tn-avatar"> <%=SPBHtmlHelper.Instance().ShowUserAvatar(user.UserName,true, HyperLinkTarget._blank, AvatarSizeTypes.Small,true) %></div>
        <a href="<%=SiteUrls.Instance().UserDomainHome(user)%>" class="tn-user-name"> <%=SPBHtmlHelper.Instance().UserDisplayName(user) %></a></li>
      <%}}%>
    </ul>
    <p class="tn-more"><a href="<%=SPBUrlHelper.Action("MemberRanks","Channel",new RouteValueDictionary{{"sortBy",sortBy}}) %>"><%=GetResourceString("Action_More")%></a></p>

  </div>
</div>
<div class="tn-blank10"> </div>
