﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    
    int applicationID = ApplicationIDs.Instance().User();
    if (CurrentUser != null && CurrentUser.UserType == UserTypes.PersonUser)
    {
        PersonUser personUser = CurrentUser as PersonUser; 
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-members-quick-search">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%=GetResourceString("Title_FastSearch",applicationID) %></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-list">
            <%if (!string.IsNullOrEmpty(personUser.HomeAreaCode))
              {
                  Response.Write(string.Format("<li><a href=\"{0}\" class=\"tn-helper-right\">{2}</a>{1}</li>", SPBUrlHelper.Action("UserSearch", "ChannelUser", new RouteValueDictionary { { "HomeAreaCode", personUser.HomeAreaCode } }), StringUtils.Trim(Formatter.FormatArea(personUser.HomeAreaCode, true), 13), GetResourceString("Action_SearchFriendsFromSameTown", applicationID)));
              }
              else
              {
                  Response.Write(string.Format("<li><a href=\"javascript:;\" class=\"tn-helper-right\" title=\"{1}\">{2}</a><a target=\"_blank\" href=\"{0}#editProfile\">{3}</a></li>", SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", personUser.UserName }, { "type", PersonProfileType.BasicInfo } }), GetResourceString("Description_FillMyHomeTown", applicationID), GetResourceString("Action_SearchFriendsFromSameTown", applicationID), GetResourceString("Action_FillMyHomeTown", applicationID)));
              }

              if (!string.IsNullOrEmpty(personUser.NowAreaCode))
              {
                  Response.Write(string.Format("<li><a href=\"{0}\" class=\"tn-helper-right\">{2}</a>{1}</li>", SPBUrlHelper.Action("UserSearch", "ChannelUser", new RouteValueDictionary { { "NowAreaCode", personUser.NowAreaCode } }), StringUtils.Trim(Formatter.FormatArea(personUser.NowAreaCode, true), 13), GetResourceString("Action_SearchFriendsFromSameLiveCity", applicationID)));
              }
              else
              {
                  Response.Write(string.Format("<li><a href=\"javascript:;\" class=\"tn-helper-right\" title=\"{1}\">{2}</a><a target=\"_blank\" href=\"{0}#editProfile\">{3}</a></li>", SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", personUser.UserName }, { "type", PersonProfileType.BasicInfo } }), GetResourceString("Description_FillMyLiveCity", applicationID), GetResourceString("Action_SearchFriendsFromSameLiveCity", applicationID), GetResourceString("Action_FillMyLiveCity", applicationID)));
              }

              if (!string.IsNullOrEmpty(personUser.School))
              {
                  Response.Write(string.Format("<li><a href=\"{0}\" class=\"tn-helper-right\">{2}</a>{1}</li>", SPBUrlHelper.Action("UserSearch", "ChannelUser", new RouteValueDictionary { { "School", WebUtils.UrlEncode(personUser.School) } }), StringUtils.Trim(personUser.School, 13), GetResourceString("Action_SearchFriendsFromSameSchool", applicationID)));
              }
              else
              {
                  Response.Write(string.Format("<li><a href=\"javascript:;\" class=\"tn-helper-right\" title=\"{1}\">{2}</a><a target=\"_blank\" href=\"{0}#editProfile\">{3}</a></li>", SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", personUser.UserName }, { "type", PersonProfileType.BasicInfo } }), GetResourceString("Description_FillMySchool", applicationID), GetResourceString("Action_SearchFriendsFromSameSchool", applicationID), GetResourceString("Action_FillMyShool", applicationID)));
              }

              if (!string.IsNullOrEmpty(personUser.CompanyName))
              {
                  Response.Write(string.Format("<li><a href=\"{0}\" class=\"tn-helper-right\">{2}</a>{1}</li>", SPBUrlHelper.Action("UserSearch", "ChannelUser", new RouteValueDictionary { { "CompanyName", WebUtils.UrlEncode(personUser.CompanyName) } }), StringUtils.Trim(personUser.CompanyName, 13), GetResourceString("Action_SearchFriendsFromSameCompany", applicationID)));
              }
              else
              {
                  Response.Write(string.Format("<li><a href=\"javascript:;\" class=\"tn-helper-right\" title=\"{1}\">{2}</a><a target=\"_blank\" href=\"{0}#editProfile\">{3}</a></li>", SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", personUser.UserName }, { "type", PersonProfileType.BusinessContact } }), GetResourceString("Description_FillMyCompany", applicationID), GetResourceString("Action_SearchFriendsFromSameCompany", applicationID), GetResourceString("Action_FillMyCompany", applicationID)));
              }

              if (personUser.CompanyTrade > 0)
              {
                  Response.Write(string.Format("<li><a href=\"{0}\" class=\"tn-helper-right\">{2}</a>{1}</li>", SPBUrlHelper.Action("UserSearch", "ChannelUser", new RouteValueDictionary { { "CompanyTrade", personUser.CompanyTrade } }), StringUtils.Trim(CodeItems.GetCodeItems(CodeSetCodes.Instance().Trade())[personUser.CompanyTrade].Name, 13), GetResourceString("Action_SearchFriendsFromSameCompanyTrade", applicationID)));
              }
              else
              {
                  Response.Write(string.Format("<li><a href=\"javascript:;\" class=\"tn-helper-right\" title=\"{1}\">{2}</a><a target=\"_blank\" href=\"{0}#editProfile\">{3}</a></li>", SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", personUser.UserName }, { "type", PersonProfileType.BusinessContact } }), GetResourceString("Description_FillMyCompanyTrade", applicationID), GetResourceString("Action_SearchFriendsFromSameCompanyTrade", applicationID), GetResourceString("Action_FillMyCompanyTrade", applicationID)));
              }

              if (!string.IsNullOrEmpty(personUser.Interest))
              {
                  Response.Write(string.Format("<li><a href=\"{0}\" class=\"tn-helper-right\">{2}</a>{1}</li>", SPBUrlHelper.Action("UserSearch", "ChannelUser", new RouteValueDictionary { { "Interest", WebUtils.UrlEncode(personUser.Interest) } }), StringUtils.Trim(personUser.Interest, 13), GetResourceString("Action_SearchFriendsFromSameInterest", applicationID)));
              }
              else
              {
                  Response.Write(string.Format("<li><a href=\"javascript:;\" class=\"tn-helper-right\" title=\"{1}\">{2}</a><a target=\"_blank\" href=\"{0}#editProfile\">{3}</a></li>", SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", personUser.UserName }, { "type", PersonProfileType.BasicInfo } }), GetResourceString("Description_FillMyInterest", applicationID), GetResourceString("Action_SearchFriendsFromSameInterest", applicationID), GetResourceString("Action_FillMyInterest", applicationID)));
              }%>
        </ul>
        <p class="tn-more">
            <a href="<%=SPBUrlHelper.Action("UserSearch","ChannelUser") %>">
                <%=GetResourceString("Common_AdvancedSearch")%></a></p>
    </div>
</div>
<div class="tn-blank10">
</div>
<%}%>
