﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<ICollection<OnlineUser>>" %>
<%    
    if (Model != null && Model.Count > 0)
    {%>
<%int applicationID = ApplicationIDs.Instance().User(); %>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-members-online-block">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=GetResourceString("Title_OnlineMember",applicationID)%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-list">
      <%
        foreach (OnlineUser user in Model)
                {                
            %>
      <li class="tn-list-item tn-helper-clearfix">
        <div class="tn-list-item-area-left">
          <div class="tn-avatar"> <%=SPBHtmlHelper.Instance().ShowUserAvatar(user.UserID,true, HyperLinkTarget._blank, AvatarSizeTypes.Small) %></div>
        </div>
        <div class="tn-list-item-area-main">
          <div class="tn-list-item-row tn-list-item-heading">
            <h5 class="tn-helper-reset"> <a href="<%=SiteUrls.Instance().UserDomainHome(user.UserID) %>"><%=SPBHtmlHelper.Instance().UserDisplayName(user.UserID,true)%></a></h5>
          </div>
          <%string microblog = MicroBlogUserDatas.GetUserData(user.UserID, false).MostRecentThreadBody;
                      if (!string.IsNullOrEmpty(microblog))
                      {%>
          <div class="tn-list-item-row tn-list-item-summary">
            <div class="spb-i-said"> &nbsp;<span class="tn-icon tn-icon-quotes-before tn-icon-inline"></span><%=microblog%><span class="tn-icon tn-icon-quotes-after tn-icon-inline"></span></div>
          </div>
          <%}%>
        </div>
      </li>
      <%} %>
    </ul>
    <p class="tn-more"><a href="<%=SPBUrlHelper.Action("OnlineMembers","Channel") %>"><%=GetResourceString("Action_More")%></a></p>
  </div>
</div>
<%} %>
