﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<RecommendedItem>>" %>
<spb:Script runat="server" ID="qtip" Src="~/Utility/jquery/plugin/jquery.qtip-1.0.0-rc3.js"
        SetExpireDays="30" />
<%if (ViewData.Model != null && ViewData.Model.Count > 0)
  {%>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-members-star-block">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset">
      <% if (ViewData["RecommendactionType"] != null)
               {
                   RecommendationType recommendationType = ViewData.Get<RecommendationType>("RecommendactionType");
                   Response.Write(recommendationType.GetMultilingualRecommendationTypeName(CurrentUserLanguage));
               }%>
    </h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul id="starMemberUL" class="tn-list tn-helper-reset">
      <%foreach (RecommendedItem item in Model)
              {%>
      <li class="tn-list-item tn-helper-clearfix">
        <div class="tn-list-item-area-left">
          <div class="tn-avatar" value="<%=item.ItemID %>"> <%=SPBHtmlHelper.Instance().ShowUserAvatar(item.ItemID,true, HyperLinkTarget._blank, AvatarSizeTypes.Small) %></div>
        </div>
        <div class="tn-list-item-area-main">
          <div class="tn-list-item-row tn-list-item-heading">
            <h5 class="tn-helper-reset"> <a href="<%=SiteUrls.Instance().UserChannelHome(item.ItemID, UserDomainSpecialAppIDs.Instance().Home()) %>"> <%=SPBHtmlHelper.Instance().UserDisplayName(item.ItemID,true) %></a></h5>
          </div>
          <%string microblog = MicroBlogUserDatas.GetUserData(item.ItemID, false).MostRecentThreadBody;
                      if (!string.IsNullOrEmpty(microblog))
                      {%>
          <div class="tn-list-item-row tn-list-item-summary">
            <div class="spb-i-said"> &nbsp;<span class="tn-icon tn-icon-quotes-before tn-icon-inline"></span><%=microblog%><span
                                class="tn-icon tn-icon-quotes-after tn-icon-inline"></span></div>
          </div>
          <%}%>
        </div>
      </li>
      <%}%>
    </ul>
  </div>
</div>
<div class="tn-blank10"> </div>
<script type="text/javascript">
                $(document).ready(function() {
                $("div.tn-avatar", $("#starMemberUL")).each(function() {
                        var self = $(this);
                        self.qtip({
                            content: '<div class="tn-loading"></div>',
                            position: {
                                corner: {
                                    target: 'rightTop',
                                    tooltip: 'leftTop'
                                },
                                adjust: {
                                    screen: true
                                }
                            },
                            show: {
                                when: 'mouseover',
                                solo: true,
                                delay: 1000
                            },
                            hide: { when: 'mouseout', fixed: true, delay: 480 },
                            style: {
                                tip: false,
                                border: {
                                    width: 0,
                                    radius: 0
                                },
                                background: 'none',
                                name: 'light',
                                width: 325,
                                padding: 1
                            },
                            api: { onShow: function() {
                                if (self.qtip('api').elements.content.is(":has(div.tn-loading)"))
                                    $.get('<%=SPBUrlHelper.Action("Control_MemberCard", "Channel")%>', { userID: self.attr("value") }, function(data) {
                                        self.qtip('api').updateContent(data);
                                    });
                            }
                            }
                        });
                    });
                });
</script>
<%}%>
