﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<RecommendedItem>>" %>
<%if (ViewData.Model != null && ViewData.Model.Count > 0)
  {%>
<ul class="tn-list tn-helper-reset">
    <%foreach (var item in ViewData.Model)
      {%>
    <li class="tn-list-item tn-helper-clearfix">
        <div class="tn-list-item-area-left">
            <div class="tn-avatar">
                <%=SPBHtmlHelper.Instance().ShowUserAvatar(item.ItemID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></div>
        </div>
        <div class="tn-list-item-area-main">
            <div class="tn-list-item-row tn-list-item-heading">
            <h5 class="tn-helper-reset">
                <a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(item.ItemID, UserDomainSpecialAppIDs.Instance().Home()) %>">
                    
                      <%=SPBHtmlHelper.Instance().UserDisplayName(item.ItemID ,true) %> 
                </a>

                 </h5>
            </div>
            <%string microblog = MicroBlogUserDatas.GetUserData(item.ItemID, false).MostRecentThreadBody;
              if (!string.IsNullOrEmpty(microblog))
              {%>
            <div class="tn-list-item-row tn-list-item-summary">
                <div class="spb-i-said">
                    &nbsp;<span class="tn-icon tn-icon-quotes-before tn-icon-inline"></span>
                    <%=microblog%>
                    <span class="tn-icon tn-icon-quotes-after tn-icon-inline"></span>
                </div>
            </div>
            <%}%>
        </div>
    </li>
    <%}%>
</ul>
<%}
  else
      Response.Write(GetResourceString("Description_NoRecommendUser", ApplicationIDs.Instance().User()));
%>
