﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<RecommendedItem>>" %>
<%if (ViewData.Model != null && ViewData.Model.Count > 0)
  {%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%if (ViewData["RecommendationType"] != null)
              {
                  RecommendationType recommendationType = ViewData.Get<RecommendationType>("recommendationType");
                  Response.Write(recommendationType.GetMultilingualRecommendationTypeName(CurrentUserLanguage));
              }
            %></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-helper-reset tn-list">
            <%foreach (var item in ViewData.Model)
              {
            %>
            <li class="tn-img-sprite tn-list-bullet"><cite class="tn-helper-right tn-text-note">
                <%=SPBHtmlHelper.Instance().UserDisplayNameLink(item.AuthorUserID,item.Author) %>
            </cite><a href="<%=SiteUrls.Instance().ShowNews(item.ItemID) %>" title="<%=item.ItemName %>">
                <%=StringUtils.Trim(item.ItemName,12,string.Empty) %></a></li>
            <%} %>
        </ul>
    </div>
</div>
<div class="tn-blank10">
</div>
<%}%>
