﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<NewsComment>>" %>
<% int returnToPageIndex = ViewData.Model.PageIndex;
   if (ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1)
   {
       returnToPageIndex = ViewData.Model.PageIndex - 1;
   }
   NewsThread thread = ViewData.Get<NewsThread>("thread");

   int NewsApplicationID = ApplicationIDs.Instance().News();
%>
<div class="tn-comment-wrap" id="commentForLoad">
    <div class="tn-list-header">
        <div class="tn-text-heading tn-border-bottom tn-border-gray">
            <h4>
                <%=GetResourceString("Common_Comment") %>
                <span class="tn-text-note">(<%=string.Format(GetResourceString("Description_Pattern_AllComment", NewsApplicationID), Model.TotalRecords)%>)</span>
            </h4>
        </div>
    </div>
    <%if (Model != null && Model.Records.Count > 0)
      {%>
    <ul class="tn-comments tn-helper-reset">
        <%foreach (var comment in ViewData.Model.Records)
          {
        %>
        <li class="tn-comment-item tn-border-gray tn-border-bottom">
            <a name="<%=comment.CommentID %>" id="<%=comment.CommentID %>"></a>
            <div class="tn-comment tn-helper-clearfix">
                <div class="tn-comment-avatar">
                    <div class="tn-avatar">
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(comment.UserID, AvatarSizeTypes.Small)%></div>
                </div>
                <%if (CurrentUser != null && (CurrentUser.UserID == comment.UserID || CurrentUser.IsContentAdministrator))
                  { %>
                <a class="tn-icon tn-icon-cross tn-helper-right" href="javascript:;" onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteComment")%>')) {$.post('<%=SPBUrlHelper.Action("DeleteComment","ChannelNews",new RouteValueDictionary{{"commentID",comment.CommentID},{"newsID",comment.ThreadID},{"pageIndex",returnToPageIndex}}) %>',function(data){$('#commentForLoadDiv').html(data);})}">
                </a>
                <%} %>
                <div class="tn-comment-info">
                    <div class="tn-commentator">
                        <h5>
                            <%=SPBHtmlHelper.Instance().UserDisplayNameLink(comment.UserID,comment.Author) %>
                        </h5>
                        <em class="tn-text-note tn-date">
                            <%=Formatter.FormatDate(comment.PostDate,true)%></em>
                        <% if (CurrentUser != null && comment.UserID != CurrentUser.UserID && CurrentUser != null)
                           { %>
                        <span class="tn-text-note">
                            <a href="javascript:;" onclick="$('#commentBody').focus().attr('value','<%=string.Format("{0}{1}：",GetResourceString("Common_Reply"),comment.Author) %>');$('#parentID').attr('value','<%=comment.CommentID %>');">
                                <%=GetResourceString("Common_Reply")%></a></span>
                        <%} %>
                    </div>
                    <%if (comment.ParentID > 0)
                      { %>
                    <blockquote class="tn-cue-tips tn-bg-gray tn-border-gray">
                        <p>
                            <%=GetResourceString("Common_Reply")%>
                            <%if (comment.ParentUserID > 0)
                              { %>
                            <a href="<%=SiteUrls.Instance().UserDomainHome(comment.ParentUserID) %>" class="tn-author">
                                <%=comment.ParentAuthor%></a>
                            <%} %>
                            <em class="tn-text-note tn-date">
                                <%=Formatter.FormatDate(comment.ParentPostDate, true)%></em></p>
                        <p>
                            <%=comment.ParentBody%></p>
                    </blockquote>
                    <%} %>
                    <p>
                        <%=comment.Body %></p>
                </div>
            </div>
        </li>
        <% 
            }%>
    </ul>
    <div class="tn-pagination tn-helper-align-center">
        <%= SPBHtmlHelper.Instance().PagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 7, SPBUrlHelper.Action("ShowNews", "ChannelNews", new RouteValueDictionary { { "newsID", thread.ThreadID }, { "pageIndex", "{0}" } }))%>
    </div>
    <%}%>
    <%
        if (thread.EnableComments)
        {
            if (SiteSettingsManager.GetSiteSettings().EnableAnonymousPosting || CurrentUser != null && NewsPermission.Validate(thread, CurrentUser, PermissionItemKeys.Instance().CreateNewsComment()))
            {

                if (TempData["StatusMessageType"] != null)
                {
                    StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
                    TempData["StatusMessageType"] = null;
                    TempData["StatusMessageContent"] = null;
                }
    %>
    <div class="tn-blank10">
    </div>
    <form id="commentForm" method="post" action="<%=SPBUrlHelper.Action("CreateComment", "ChannelNews", new RouteValueDictionary { { "newsID", Html.GetParameterFromRouteDateOrQueryString("newsID", 0) }, { "pageIndex",Model.PageIndex } })%>">
    <div class="tn-form tn-label-top">
        <div class="tn-comment-form-wrap tn-bg-gray">
            <div class="tn-comment-form">
                <div class="tn-comment-form tn-emotion-box">
                    <a name="comments" id="comments"></a>
                    <%  Html.RenderAction<ChannelController>(n => n.Control_SmileySelector("SmileySelector", "commentBody"));%>
                    <div class="tn-comment-text-wrap tn-border-gray tn-form-row-near">
                        <textarea id="commentBody" class="tn-comment-text-area" name="commentBody"><%=TempData.GetString("commentBody",string.Empty) %></textarea><br />
                        <input type="hidden" id="parentID" name="parentID" value="<%=TempData.GetInt("parentID", 0)%>" />
                    </div>
                    <div class="tn-form-row tn-text-note">
                        <%=string.Format(GetResourceString("Description_Pattern_WordCountLimit"), UserDomainConfiguration.Instance().MaxLengthPerReply)%>
                    </div>
                </div>
            </div>
            <%SiteSettings settings = SiteSettingsManager.GetSiteSettings();
              if (settings.VerifyCodeOption == VerifyCodeOption.Enabled || CurrentUser == null && settings.VerifyCodeOption == VerifyCodeOption.Anonymous)
              {%>
            <div class="tn-form-row tn-form-row-verifycode">
                <label>
                    <%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon")%></label>
                <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode", VerificationCodeDifficultyLevel.Low)%>
            </div>
            <%}%>
            <div class="tn-form-row tn-form-row-button">
                <%=SPBHtmlHelper.Instance().SubmitButton("submitComment", GetResourceString("Button_Release", NewsApplicationID))%>
            </div>
        </div>
    </div>
    </form>

    <script type="text/javascript">
     $(document).ready(function() {         
        $("#commentForm").validate({
           rules: { 
            commentBody:{ required: true, maxBlength: <%=UserDomainConfiguration.Instance().MaxLengthPerReply%> },
            verifyCode:{required:true}
           },
           messages:{
            commentBody:{ required: "<%=GetResourceString("Validate_InputComment",NewsApplicationID) %>", maxBlength: "<%=string.Format(GetResourceString("Validate_MaxLengthNotExceedWord", NewsApplicationID), UserDomainConfiguration.Instance().MaxLengthPerReply)%>" },
            verifyCode:{required: "<%=GetResourceString("Validate_FillInValidate") %>"}
           }
        }); 
        
       $("#submitComment").click(function() {
            if (!$("#commentForm").valid()) {
                return false;
            }
          });
        $('#commentForm').ajaxForm({
            target: '#commentForLoadDiv',
            cache:false,
            beforeSubmit: function() {
                $('#commentForm').block({
                    message: '<%=GetResourceString("Message_Loading")%>'
                });
            },
            success: function() {
                $('#commentForm').unblock();
            }
        });
        
        $('.nyroModal').nyroModal({
            resizeable: true
        });
    }); 
    </script>

    <%}
            else { Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Hint, GetResourceString("Message_PopedomNotComment"), false)); }

        }
        else { Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Hint, GetResourceString("Message_CommentAlreadyClose", NewsApplicationID), false)); } %>
</div>
