﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<NewsThread>>" %>
<%if (ViewData.Model.Count > 0)
  {%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%=GetResourceString("Title_HotAppraiseNews", ApplicationIDs.Instance().News())%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-helper-reset tn-list">
            <%foreach (var thread in ViewData.Model)
              {%>
            <li><cite class="tn-count tn-text-note tn-helper-right">
                <%=thread.CommentCount %></cite>•&nbsp;&nbsp;<a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ShowNews(thread.ThreadID)) %>"
                    title="<%=thread.Title %>"><%=StringUtils.Trim(thread.Title,12,string.Empty) %></a></li>
            <%}%>
        </ul>
    </div>
</div>
<div class="tn-blank10">
</div>
<%}%>