﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<NewsThread>>" %>
<%if (Model != null && Model.Count > 0)
  {
      NewThreadsSortBy sortBy = ViewData.Get<NewThreadsSortBy>("sortBy", NewThreadsSortBy.HitTimes);

%>

<div id="ListNewsBlock-<%=sortBy.ToString() %>" class="tn-box tn-widget tn-widget-content tn-corner-all spb-new-stories">
  <%if (!string.IsNullOrEmpty(ViewData.GetString("TitleName", string.Empty)))
      { %>
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=ViewData.GetString("TitleName",string.Empty)%></h3>
  </div>
  <%} %>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-helper-clearfix tn-list tn-list-symmetry">
      <li class="tn-helper-clearfix tn-list-first">
        <%if (Model[0] != null && Model[0].FeaturedImageAttachmentID > 0)
                  {                          
                %>
        <div class="tn-list-item-area-left"> <a href="<%=SiteUrls.Instance().ShowNews(Model[0].ThreadID) %>"> <img alt="<%=Model[0].Title %>" src="<%=SiteUrls.Instance().NewsPhotoUrl(Model[0].FeaturedImageAttachmentID, NewsPhotoTypes.Title) %>" /></a> </div>
        <%}%>
        <div class="tn-list-item-area-main">
          <div class="tn-list-item-row tn-list-item-heading">
            <h5 class="tn-helper-reset"> <a title="<%=Model[0].Title %>" href="<%=SiteUrls.Instance().ShowNews(Model[0].ThreadID) %>">
              <%if (Model[0].FeaturedImageAttachmentID > 0) { Response.Write(StringUtils.Trim(Model[0].Title, 40, string.Empty)); } else { Response.Write(StringUtils.Trim(Model[0].Title, 80, string.Empty)); }%>
              </a></h5>
          </div>
          <div class="tn-list-item-row"> <em class="tn-date tn-text-note"> <%=Formatter.FormatDate(Model[0].PostDate)%></em> </div>
          <div class="tn-list-item-row tn-list-item-summary">
            <%if (string.IsNullOrEmpty(Model[0].Excerpt)) { Response.Write(HtmlUtils.TrimHtml(Model[0].ForcedExcerpt, 50)); } else { Response.Write(HtmlUtils.TrimHtml(Model[0].Excerpt, 50)); }%>
          </div>
        </div>
      </li>
      <%for (int i = 1; i < Model.Count; i++)
              {
                  NewsThread thread = Model[i];
                  if (thread == null)
                      continue;%>
      <li><em class="tn-text-note tn-helper-right">
        <%switch (sortBy)
                  {
                      case NewThreadsSortBy.HitTimes:
                          Response.Write(thread.HitTimes);
                          break;
                      case NewThreadsSortBy.CommentCount:
                          Response.Write(thread.CommentCount);
                          break;
                      case NewThreadsSortBy.PostDate:
                          Response.Write(Formatter.FormatDate(thread.PostDate));
                          break;
                      case NewThreadsSortBy.StageCommentCount:
                          Response.Write(thread.StageCommentCount);
                          break;
                      case NewThreadsSortBy.StageHitTimes:
                          Response.Write(thread.StageHitTimes);
                          break;
                      case NewThreadsSortBy.StickyAndPostDate:
                          Response.Write(Formatter.FormatDate(thread.PostDate));
                          break;
                      default:
                          Response.Write(thread.HitTimes);
                          break;
                  } %>
        </em><a href="<%=SiteUrls.Instance().ShowNews(thread.ThreadID) %>" title="<%=thread.Title %>"> <%=StringUtils.Trim(thread.Title, 50,string.Empty)%></a> </li>
      <%}%>
    </ul>
  </div>
</div>
<div class="tn-blank10"> </div>
<%} %>
