﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<NewsThread>>" %>
<%if (Model != null && ViewData.Model.Count > 0)
  {
      NewThreadsSortBy sortBy = ViewData.Get<NewThreadsSortBy>("sortBy", NewThreadsSortBy.HitTimes);
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <%if (!string.IsNullOrEmpty(ViewData.GetString("TitleName", string.Empty)))
      { %>
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%=ViewData.GetString("TitleName",string.Empty)%></h3>
    </div>
    <%} %>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-helper-reset tn-list">
            <%foreach (var thread in ViewData.Model)
              {
                  if (thread == null)
                      continue;
            %>
            <li><cite class="tn-count tn-text-note tn-helper-right">
                <%switch (sortBy)
                  {
                      case NewThreadsSortBy.HitTimes:
                          Response.Write(thread.HitTimes);
                          break;
                      case NewThreadsSortBy.CommentCount:
                          Response.Write(thread.CommentCount);
                          break;
                      case NewThreadsSortBy.PostDate:
                          Response.Write(Formatter.FormatDate(thread.PostDate));
                          break;
                      case NewThreadsSortBy.StageCommentCount:
                          Response.Write(thread.StageCommentCount);
                          break;
                      case NewThreadsSortBy.StageHitTimes:
                          Response.Write(thread.StageHitTimes);
                          break;
                      case NewThreadsSortBy.StickyAndPostDate:
                          Response.Write(Formatter.FormatDate(thread.PostDate));
                          break;
                      default:
                          Response.Write(thread.HitTimes);
                          break;
                  } %>
            </cite>
            <%if(thread.Section!=null){ %>
            <%--<a href="<%=SPBUrlHelper.Action("ListNewsForChild", "ChannelNews", new RouteValueDictionary { { "sectionID", thread.SectionID } })%>"
                class="tn-secondary-text tn-category">【<%=thread.Section.SectionName%>】</a>--%>
                <%} %>
                <a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ShowNews(thread.ThreadID)) %>"
                    title="<%=thread.Title %>"><%=StringUtils.Trim(thread.Title,15,string.Empty) %></a></li>
            <%}%>
        </ul>
    </div>
</div>
<div class="tn-blank10">
</div>
<%}%>