﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<NewsThread>>" %>
<h4 class="tn-border-gray tn-border-bottom">
    <%=ViewData.GetString("TitleName", GetResourceString("Title_HotNews", ApplicationIDs.Instance().News()))%></h4>
<%if (Model != null && ViewData.Model.Count > 0)
  {%>
<ul class="tn-list">
    <li class="tn-helper-clearfix tn-list-first">
        <h5>
            <a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ShowNews(Model[0].ThreadID)) %>"
                title="<%=Model[0].Title %>">
                <%=HtmlUtils.TrimHtml(Model[0].Title,20) %></a></h5>
        <%if (Model[0] != null && Model[0].FeaturedImageAttachmentID > 0)
          { %>
        <div class="tn-title-pic">
            <a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ShowNews(Model[0].ThreadID)) %>">
                <img alt="<%=Model[0].Title %>" src="<%=SiteUrls.Instance().NewsPhotoUrl(Model[0].FeaturedImageAttachmentID, NewsPhotoTypes.Title) %>" /></a></div>
        <%} %>
        <p>
            <%=HtmlUtils.TrimHtml(Model[0].ForcedExcerpt, 50)%><a class="tn-secondary-text tn-more"
                href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ShowNews(Model[0].ThreadID)) %>">【详细】</a></p>
    </li>
    <%for (int i = 1; i < Model.Count; i++)
      {
          if (Model[i] == null)
              continue;%>
    <li>
    <%if(Model[i].Section!=null){ %>
    <a href="<%=SPBUrlHelper.Action("ListNewsForChild", "ChannelNews", new RouteValueDictionary { { "sectionID", Model[i].SectionID } })%>"
        class="tn-secondary-text tn-category">【<%=Model[i].Section.SectionName %>】</a>
        <%} %>
         <a
            title="<%=Model[i].Title %>" href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ShowNews(Model[i].ThreadID)) %>">
            <%=Model[i].Title %></a></li>
    <%}
  } %>
</ul>
