﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%foreach (var dict in ViewData["sectionThread"] as Dictionary<NewsSection, IList<NewsThread>>)
          {
              if (dict.Value.Count > 0)
              {%>

<div id="NewsSection-<%=dict.Key.SectionID %>" class="tn-box tn-widget tn-widget-content tn-corner-all">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=dict.Key.GetMultilingualSectionName(CurrentUserLanguage)%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-helper-reset tn-helper-clearfix tn-list tn-list-symmetry">
      <li class="tn-helper-clearfix tn-list-first">
        <%if (dict.Value[0].FeaturedImageAttachmentID > 0)
                          {                          
                        %>
        <div class="tn-list-item-area-left"> <a href="<%=SiteUrls.Instance().ShowNews(dict.Value[0].ThreadID) %>"> <img alt="<%=dict.Value[0].Title %>" src="<%=SiteUrls.Instance().NewsPhotoUrl(dict.Value[0].FeaturedImageAttachmentID, NewsPhotoTypes.Title) %>" /></a> </div>
        <%}%>
        <div class="tn-list-item-area-main">
          <div class="tn-list-item-row tn-list-item-heading">
            <h5 class="tn-helper-reset"> <a title="<%=dict.Value[0].Title %>" href="<%=SiteUrls.Instance().ShowNews(dict.Value[0].ThreadID) %>"
                                        title="<%=dict.Value[0].Title %>">
              <%if (dict.Value[0].FeaturedImageAttachmentID > 0) { Response.Write(StringUtils.Trim(dict.Value[0].Title, 40, string.Empty)); } else { Response.Write(StringUtils.Trim(dict.Value[0].Title, 80, string.Empty)); }%>
              </a></h5>
          </div>
          <div class="tn-list-item-row"> <cite> <%=Formatter.FormatDate(dict.Value[0].PostDate)%></cite> </div>
          <div class="tn-list-item-row tn-list-item-summary">
            <%if (string.IsNullOrEmpty(dict.Value[0].Excerpt)) { Response.Write(HtmlUtils.TrimHtml(dict.Value[0].ForcedExcerpt, 50)); } else { Response.Write(HtmlUtils.TrimHtml(dict.Value[0].Excerpt, 50)); }%>
          </div>
        </div>
      </li>
      <%for (int i = 1; i < dict.Value.Count; i++)
                      {
                          NewsThread thread = dict.Value[i];%>
      <li><cite class="tn-helper-right"> <%=Formatter.FormatDate(thread.PostDate)%></cite> •&nbsp;&nbsp;<a href="<%=SiteUrls.Instance().ShowNews(dict.Value[i].ThreadID) %>"
                            title="<%=thread.Title %>"> <%=StringUtils.Trim(thread.Title, 50,string.Empty)%></a> </li>
      <%}%>
    </ul>
    <p class="tn-more"><a href="<%=SPBUrlHelper.Action("ListNewsForChild","ChannelNews",new RouteValueDictionary{{"sectionID",dict.Key.SectionID}}) %>"> <%=GetResourceString("Action_More")%></a> </p>
  </div>
</div>
<div class="tn-blank10"> </div>
<%}
          }%>