﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<NewsThread>>" %>

<spb:Script runat="server" ID="Script1" Src="~/Utility/jquery/plugin/jquery.slideshow.lite-0.5.3.js"
    SetExpireDays="30" />
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-top-stories">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=GetResourceString("Widget_modulePrefs_ListNewsSildeBlock_Name")%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <div class="tn-helper-clearfix">
      <%List<NewsThread> newsSlide = ViewData["listSlideNews"] as List<NewsThread>;
                    if (newsSlide.Count > 0)
                    { %>
      <div id="newsSlideShow">
        <%foreach (var slideThread in newsSlide)
                       {%>
        <a style="display:none;" href="<%=SiteUrls.Instance().ShowNews(slideThread.ThreadID) %>"> <img src="<%=SiteUrls.Instance().NewsPhotoUrl(slideThread.FeaturedImageAttachmentID, NewsPhotoTypes.Slide) %>"
                    alt="<%=StringUtils.Trim(slideThread.Title,22)%>" rel="<%=SiteUrls.Instance().ShowNews(slideThread.ThreadID) %>" /></a>
        <%}%>
      </div>
      <%} %>
      <ul class="tn-list tn-helper-flowfix">
        <%if (ViewData.Model != null && ViewData.Model.Count > 0)
      {%>
        <%NewsThread topThread = ViewData.Model[0];
      if (topThread != null)
      {%>
        <li class="tn-helper-clearfix tn-list-first">
          <%if (topThread.FeaturedImageAttachmentID > 0)
          {%>
          <div class="tn-list-item-area-left"> <a href="<%=SiteUrls.Instance().ShowNews(topThread.ThreadID) %>"> <img src="<%=SiteUrls.Instance().NewsPhotoUrl(topThread.FeaturedImageAttachmentID, NewsPhotoTypes.Title) %>" /></a> </div>
          <%}%>
          <div class="tn-list-item-area-main">
            <div class="tn-list-item-row tn-list-item-heading">
              <h5 class="tn-helper-reset"> <a title="<%=topThread.Title%>" href="<%=SiteUrls.Instance().ShowNews(topThread.ThreadID) %>" title="<%=topThread.Title %>">
                <%if (newsSlide.Count > 0) { Response.Write(StringUtils.Trim(topThread.Title, 26)); } else { Response.Write(StringUtils.Trim(topThread.Title, 30)); } %>
                </a> </h5>
            </div>
            <div class="tn-list-item-row tn-list-item-summary">
              <p>
                <%if (newsSlide.Count > 0) { if (string.IsNullOrEmpty(topThread.Excerpt)) { Response.Write(HtmlUtils.TrimHtml(topThread.ForcedExcerpt, 49)); } else { Response.Write(HtmlUtils.TrimHtml(topThread.Excerpt, 49)); } } else { if (string.IsNullOrEmpty(topThread.Excerpt)) { Response.Write(HtmlUtils.TrimHtml(topThread.ForcedExcerpt, 132)); } else { Response.Write(HtmlUtils.TrimHtml(topThread.Excerpt, 132)); } }  %>
              </p>
            </div>
          </div>
        </li>
        <%}%>
        <%for (int i = 1; i < ViewData.Model.Count; i++)
          {
              NewsThread thread = ViewData.Model[i];
              if (thread.Section == null)
                  continue;
        %>
        <li><em class="tn-date tn-text-note tn-helper-right"><%=Formatter.FormatDate(thread.PostDate,false) %></em> <a href="<%=SiteUrls.Instance().ShowNews(thread.ThreadID) %>" title="<%=thread.Title %>"><%=StringUtils.Trim(thread.Title,17)%></a></li>
        <%}%>
        <%} %>
      </ul>
    </div>
  </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("#newsSlideShow a").show();
        $("#newsSlideShow").slideshow({ width: 320, height: 240 });
    });
</script>
