﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<NewsThread>>" %>

<ul class="tn-list">
  <%if (Model != null && Model.Count > 0)
      {
          NewsThread topThread = ViewData.Model[0];
          int applicationID = ApplicationIDs.Instance().News(); %>
  <li class="tn-helper-clearfix tn-border-gray tn-border-bottom tn-list-first">
    <%if (topThread.FeaturedImageAttachmentID > 0)
          { %>
    <div class="tn-list-item-area-left"> <a target="_blank" href="<%=SiteUrls.Instance().ShowNews(topThread.ThreadID) %>"> <img src="<%=SiteUrls.Instance().NewsPhotoUrl(topThread.FeaturedImageAttachmentID, NewsPhotoTypes.Title) %>" /> </a> </div>
    <%} %>
    <div class="tn-list-item-area-main">
      <div class="tn-list-item-row tn-list-item-heading">
        <h5 class="tn-helper-reset"> <a target="_blank" href="<%=SiteUrls.Instance().ShowNews(topThread.ThreadID) %>" title="<%=topThread.Title %>"> <%=StringUtils.Trim(topThread.Title,18,string.Empty) %></a></h5>
      </div>
      <div class="tn-list-item-row tn-list-item-summary">
        <p> <%=StringUtils.Trim(topThread.ForcedExcerpt,38) %></p>
      </div>
      <div class="tn-list-item-row"> <a class="tn-secondary-text" target="_blank" href="<%=SiteUrls.Instance().ShowNews(topThread.ThreadID) %>"> <%=GetResourceString("Action_FullText") %></a> <em class="tn-text-note"><%=GetResourceString("Label_Author") %><%=GetResourceString("Common_Colon") %></em> <a target="_blank" href="<%=SiteUrls.Instance().UserDomainHome(topThread.UserID) %>" class="tn-author tn-secondary-text"> <%=topThread.Contributor %></a> </div>
    </div>
  </li>
  <%for (int i = 1; i < Model.Count; i++)
      { %>
  <li class="tn-img-sprite tn-list-bullet">
    <%if (Model[i].SectionID > 0)
          {%>
    <a class="tn-secondary-text tn-category" target="_blank" href="<%=SiteUrls.Instance().ChannelNewsListNews(Model[i].SectionID) %>"><%=Model[i].Section.SectionName %></a>
    <%} %>
    <a target="_blank" href="<%=SiteUrls.Instance().ShowNews(Model[i].ThreadID) %>" title="<%=Model[i].Title %>"> <%=StringUtils.Trim(Model[i].Title,20) %></a> </li>
  <%}
}%>
</ul>
