﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<NewsThread>>" %>
<%int NewsApplicationID = ApplicationIDs.Instance().News();
  NewThreadsSortBy sortBy = ViewData.Get<NewThreadsSortBy>("sortBy", NewThreadsSortBy.StickyAndLastRepliedDate);
  int sectionID = Html.GetParameterFromRouteDateOrQueryString("sectionID", 0);
  int pageSize = Html.GetParameterFromRouteDateOrQueryString("pageSize", 30);
%>
<div id="ListNews" class="tn-box tn-widget tn-widget-content tn-corner-all spb-stories">
    <%if (!string.IsNullOrEmpty(ViewData.GetString("TitleName", string.Empty)))
      { %>
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%=ViewData.GetString("TitleName",string.Empty)%></h3>
    </div>
    <%} %>
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <%if (Model != null && Model.Records.Count > 0)
          {
              NewsThread topThread = Model.Records[0];
        %>
        <div class="tn-list">
            <div class="tn-helper-clearfix tn-list-top">
                <%if (topThread != null && topThread.FeaturedImageAttachmentID > 0)
                  {%>
                <div class="tn-list-item-area-left">
                    <a href="<%=SiteUrls.Instance().ShowNews(topThread.ThreadID) %>">
                        <img src="<%=SiteUrls.Instance().NewsPhotoUrl(topThread.FeaturedImageAttachmentID, NewsPhotoTypes.BigNews) %>" /></a>
                </div>
                <%} %>
                <div class="tn-list-item-area-main">
                    <div class="tn-list-item-row tn-list-item-heading">
                        <h5 class="tn-helper-reset">
                            <a title="<%=topThread.Title%>" href="<%=SiteUrls.Instance().ShowNews(topThread.ThreadID) %>">
                                <%if (topThread.FeaturedImageAttachmentID > 0) { Response.Write(StringUtils.Trim(topThread.Title, 37)); } else { Response.Write(StringUtils.Trim(topThread.Title, 48)); } %></a>
                            <%if (topThread.IsSticky)
                                  SPBHtmlHelper.Instance().Icon(IconTypes.Top);
                              if (topThread.IsEssential)
                                  SPBHtmlHelper.Instance().Icon(IconTypes.Elite);
                            %></h5>
                    </div>
                    <div class="tn-list-item-row tn-list-item-summary">
                        <p>
                            <%if (string.IsNullOrEmpty(topThread.Excerpt)) { Response.Write(HtmlUtils.TrimHtml(topThread.ForcedExcerpt, 110)); } else { Response.Write(HtmlUtils.TrimHtml(topThread.Excerpt, 110)); }%></p>
                    </div>
                    <div class="tn-list-item-row">
                        <cite><a href="<%=SiteUrls.Instance().UserChannelHome(topThread.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                            class="tn-author">
                            <%=topThread.Contributor %></a></cite> <em class="tn-date tn-text-note">发布于
                                <%=Formatter.FormatDate(topThread.PostDate, false)%></em><cite class="tn-text-note">
                                    <%=SPBHtmlHelper.Instance().ShowRating(topThread.RatingSum, topThread.TotalRatings)%>
                                </cite>
                        <%=SPBHtmlHelper.Instance().LinkButton("comment","评论"+topThread.CommentCount,SiteUrls.Instance().ShowNews(topThread.ThreadID)+"#commentBody",ButtonSizes.Default,HighlightStyles.Lite,IconTypes.Bubble,TextIconLayout.IconText) %>
                        <%=SPBHtmlHelper.Instance().LinkButton("comment", "浏览" + topThread.HitTimes, SiteUrls.Instance().ShowNews(topThread.ThreadID), ButtonSizes.Default, HighlightStyles.Lite, IconTypes.View, TextIconLayout.IconText)%>
                    </div>
                </div>
            </div>
        </div>
        <%} %>
        <div class="tn-list-header">
            <div id="NewsViewType" class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                <%=GetResourceString("Label_Display")%><%=GetResourceString("Common_Colon") %>
                <span id="headlines" class="tn-action"><a class="tn-action-text" href="javascript:;">
                    <%=GetResourceString("Label_Subject")%></a> </span><span id="summaries" class="tn-action">
                        <a class="tn-action-text" href="javascript:;">
                            <%=GetResourceString("Action_Summary",NewsApplicationID)%></a> </span>
                <span id="featureImg" class="tn-action"><a class="tn-action-text" href="javascript:;">
                    <%=GetResourceString("Action_PhotoView",NewsApplicationID)%></a> </span>
            </div>
        </div>
        <ul id="newsListUL" class="tn-list">
            <%for (int i = 1; i < Model.Records.Count; i++)
              {
                  NewsThread thread = Model.Records[i];
                  if (thread == null)
                      continue;%>
            <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                <div class="tn-list-item-area-left" style="display: none">
                    <%if (thread.FeaturedImageAttachmentID > 0)
                      {%><a href="<%=SiteUrls.Instance().ShowNews(thread.ThreadID) %>">
                          <img src="<%=SiteUrls.Instance().NewsPhotoUrl(thread.FeaturedImageAttachmentID, NewsPhotoTypes.Title) %>" /></a>
                    <%} %>
                </div>
                <div class="tn-list-item-area-main">
                    <div class="tn-list-item-row tn-list-item-heading">
                        <h5 class="tn-helper-reset">
                            <a title="<%=thread.Title%>" href="<%=SiteUrls.Instance().ShowNews(thread.ThreadID) %>">
                                <%if (thread.FeaturedImageAttachmentID > 0) { Response.Write(StringUtils.Trim(thread.Title, 40)); } else { Response.Write(StringUtils.Trim(thread.Title, 48)); }  %></a>
                            <%if (thread.IsSticky)
                                  SPBHtmlHelper.Instance().Icon(IconTypes.Top);
                              if (thread.IsEssential)
                                  SPBHtmlHelper.Instance().Icon(IconTypes.Elite);
                            %>
                            <cite class="tn-text-note"><em class="tn-date">
                                <%=Formatter.FormatDate(thread.PostDate)%></em></cite>
                        </h5>
                    </div>
                    <div class="tn-list-item-row tn-list-item-summary">
                        <p>
                            <%if (string.IsNullOrEmpty(thread.Excerpt)) { Response.Write(HtmlUtils.TrimHtml(thread.ForcedExcerpt, 108)); } else { Response.Write(HtmlUtils.TrimHtml(thread.Excerpt, 108)); }%></p>
                    </div>
                </div>
            </li>
            <%}%>
        </ul>
        <div class="tn-pagination tn-helper-align-center">
            <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListOrSummaryNewsBlock", "ChannelNews", new RouteValueDictionary { { "sectionID", sectionID }, { "sortBy", sortBy }, { "viewName", ViewData.GetString("viewName", "ListOrSummaryNewsBlockForMain") }, { "titleName", ViewData.GetString("titleName", string.Empty) }, { "pageSize", pageSize }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
        </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            $("#headlines").click(function() {
                $('#newsListUL div.tn-list-item-area-left').css('display', 'none');
                $('#newsListUL div.tn-list-item-summary').css('display', 'none');
                $('#NewsViewType span').removeClass('tn-selected');
                $(this).addClass("tn-selected");
                $.cookie('ListNewsMode1', 1);
            });

            $("#summaries").click(function() {
                $('#newsListUL div.tn-list-item-area-left').css('display', 'none');
                $('#newsListUL div.tn-list-item-summary').css('display', 'block');
                $('#NewsViewType span').removeClass('tn-selected');
                $(this).addClass("tn-selected");
                $.cookie('ListNewsMode1', 2);
            });

            $("#featureImg").click(function() {
                $('#newsListUL div.tn-list-item-area-left').css('display', 'block');
                $('#newsListUL div.tn-list-item-summary').css('display', 'block');
                $('#NewsViewType span').removeClass('tn-selected');
                $(this).addClass("tn-selected");
                $.cookie('ListNewsMode1', 3);
            });
  <% int mode = 0;
                HttpCookie cookie = Request.Cookies["ListNewsMode1"];
                       if (cookie != null)
                        {  
                         mode = Convert.ToInt32(cookie.Value);
                           if(mode == 1)
                            Response.Write("$('#headlines').click();");
                           else if(mode == 2)
                           Response.Write("$('#summaries').click();");
                           else
                            Response.Write("$('#featureImg').click();");
                            }
                       else
                           Response.Write("$('#featureImg').click();"); %>
        });
        function pageIndexChange(url) {
            $('#ListNews').parent().load(url);
        }
       
    </script>

</div>
