﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<NewsThread>>" %>
<%if (Model != null && ViewData.Model.Count > 0)
  {%>

<div id="listPhotoNews" class="tn-box tn-widget tn-widget-content tn-corner-all spb-photo-news-main">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=ViewData.GetString("TitleName", GetResourceString("Title_PhotoNews", ApplicationIDs.Instance().News()))%> </h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-photo-list tn-widget tn-helper-clearfix">
      <%foreach (var phtotThread in Model)
              {
                  if (phtotThread == null)
                      continue;
            %>
      <li class="tn-photo-item">
        <%if (phtotThread.FeaturedImageAttachmentID > 0)
                  {%>
        <p class="tn-photo-wrap tn-widget-content tn-border-gray"> <a href="<%=SiteUrls.Instance().ShowNews(phtotThread.ThreadID) %>"> <img src="<%=SiteUrls.Instance().NewsPhotoUrl(phtotThread.FeaturedImageAttachmentID, NewsPhotoTypes.Title) %>"><span></span></a></p>
        <%}%>
        <p class="tn-text-heading"> <a href="<%=SiteUrls.Instance().ShowNews(phtotThread.ThreadID) %>" title="<%=phtotThread.Title%>"> <%=StringUtils.Trim(phtotThread.Title, 9,string.Empty)%></a> </p>
      </li>
      <%}%>
    </ul>
    <p class="tn-more"><a href="<%=SPBUrlHelper.Action("ListPhotoNews","ChannelNews") %>"> <%=GetResourceString("Action_More")%></a></p>
  </div>
</div>
<%} %>
