﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<NewsThread>>" %>
<%if (Model != null && ViewData.Model.Count > 0)
  {%>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-photo-news-block">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset">
      <%if (ViewData["RecommendationType"] != null)
              {
                  RecommendationType recommendationType = ViewData.Get<RecommendationType>("recommendationType");
                  Response.Write(recommendationType.GetMultilingualRecommendationTypeName(CurrentUserLanguage));
              }
            %>
    </h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-photo-list tn-widget tn-helper-clearfix">
      <%foreach (var thread in ViewData.Model)
              {
                  if (thread == null)
                      continue;
            %>
      <li class="tn-photo-item">
        <%if (thread.FeaturedImageAttachmentID > 0)
                  {%>
        <p class="tn-photo-wrap tn-widget-content tn-border-gray"> <a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ShowNews(thread.ThreadID)) %>"> <img src="<%=SiteUrls.Instance().NewsPhotoUrl(thread.FeaturedImageAttachmentID, NewsPhotoTypes.Title)%>"><span></span></a></p>
        <%}%>
        <p class="tn-text-heading"> <a title="<%=thread.Title %>" href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ShowNews(thread.ThreadID)) %>"> <%=StringUtils.Trim(thread.Title,12,string.Empty) %></a></p>
        <p class="tn-text-note"> <em class="tn-date"> <%=Formatter.FormatDate(thread.PostDate,false) %></em></p>
      </li>
      <%}%>
    </ul>
    <p class="tn-more"><a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("ListPhotoNews","ChannelNews")) %>"> <%=GetResourceString("Action_More")%></a> </p>
  </div>
</div>
<div class="tn-blank10"> </div>
<%}%>
