﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<NewsThread>>" %>
<%if (Model != null && ViewData.Model.Count > 0)
  {
      NewThreadsSortBy sortBy = ViewData.Get<NewThreadsSortBy>("sortBy", NewThreadsSortBy.HitTimes);
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-most-popular">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%=ViewData.GetString("TitleName", GetResourceString("Title_HotNews", ApplicationIDs.Instance().News()))%>
        </h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-list">
            <%if (Model != null)
              { %>
            <li class="tn-helper-clearfix tn-list-first">
                <h5>
                    <a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ShowNews(Model[0].ThreadID)) %>"
                        title="<%=Model[0].Title %>">
                        <%=HtmlUtils.TrimHtml(Model[0].Title,20) %></a></h5>
                <%if (Model[0] != null && Model[0].FeaturedImageAttachmentID > 0)
                  { %>
                <div class="tn-title-pic">
                    <a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ShowNews(Model[0].ThreadID)) %>">
                        <img alt="<%=Model[0].Title %>" src="<%=SiteUrls.Instance().NewsPhotoUrl(Model[0].FeaturedImageAttachmentID, NewsPhotoTypes.Title) %>" /></a></div>
                <%} %>
                <p>
                    <%=HtmlUtils.TrimHtml(Model[0].ForcedExcerpt,50) %><a class="tn-secondary-text tn-more"
                        href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ShowNews(Model[0].ThreadID)) %>">【详细】</a></p>
            </li>
            <%} for (int i = 1; i < Model.Count; i++)
              {
                  if (Model[i] == null)
                      continue;
            %>
            <li><cite class="tn-count tn-text-note tn-helper-right">
                <%switch (sortBy)
                  {
                      case NewThreadsSortBy.HitTimes:
                          Response.Write(Model[i].HitTimes);
                          break;
                      case NewThreadsSortBy.CommentCount:
                          Response.Write(Model[i].CommentCount);
                          break;
                      case NewThreadsSortBy.PostDate:
                          Response.Write(Formatter.FormatDate(Model[i].PostDate));
                          break;
                      case NewThreadsSortBy.StageCommentCount:
                          Response.Write(Model[i].StageCommentCount);
                          break;
                      case NewThreadsSortBy.StageHitTimes:
                          Response.Write(Model[i].StageHitTimes);
                          break;
                      case NewThreadsSortBy.StickyAndPostDate:
                          Response.Write(Formatter.FormatDate(Model[i].PostDate));
                          break;
                      default:
                          Response.Write(Model[i].HitTimes);
                          break;
                  } %>
            </cite>
            <%if(Model[i].Section!=null){ %>
            <%--<a href="<%=SPBUrlHelper.Action("ListNewsForChild", "ChannelNews", new RouteValueDictionary { { "sectionID", Model[i].SectionID } })%>"
                class="tn-secondary-text tn-category">【<%=Model[i].Section.SectionName %>】</a>--%>
                <%} %>
                 <a
                    title="<%=Model[i].Title %>" href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ShowNews(Model[i].ThreadID)) %>">
                    <%=Model[i].Title %></a></li>
            <%} %>
        </ul>
    </div>
</div>
<div class="tn-blank10">
</div>
<%}%>