﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<UserCategory>>" %>
<% 
    int applicatonID = ApplicationIDs.Instance().Photo();
    UserCategorySortBy sortBy = UserCategorySortBy.MostRecentUpdateDate;
    if (ViewData["sortBy"] != null)
        sortBy = (UserCategorySortBy)ViewData["sortBy"];
    int pageSize = Html.GetParameterFromRouteDateOrQueryString("pageSize", 32);
    RouteValueDictionary defaultRouteValues = new RouteValueDictionary { { "pageSize", pageSize } };      
%>
<div id="galleryRanks" class="ui-tabs ui-widget ui-widget-content ui-corner-all spb-albums-main spb-album-top">
    <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
        <li id="RankByPostDateLi" <%if(UserCategorySortBy.MostRecentUpdateDate==sortBy) Response.Write("class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\""); else  Response.Write("class=\"ui-state-default ui-corner-top\""); %>>
            <a href="<%=SPBUrlHelper.Action("GalleryRanks","ChannelPhoto",new RouteValueDictionary{{"sortBy",UserCategorySortBy.MostRecentUpdateDate}}) %>"
                onclick="$('#galleryRanks').parent().load('<%=SPBUrlHelper.Action("Control_GalleryRanks","ChannelPhoto",new RouteValueDictionary(defaultRouteValues){{"sortBy",UserCategorySortBy.MostRecentUpdateDate}}) %>'); return false;">
                <span><%=GetResourceString("Title_NewPost") %></span></a></li>
        <li id="RankByPostCountLi" <%if(UserCategorySortBy.PhotoCount==sortBy) Response.Write("class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\""); else  Response.Write("class=\"ui-state-default ui-corner-top\""); %>>
            <a href="<%=SPBUrlHelper.Action("GalleryRanks","ChannelPhoto",new RouteValueDictionary{{"sortBy",UserCategorySortBy.PhotoCount}}) %>"
                onclick="$('#galleryRanks').parent().load('<%=SPBUrlHelper.Action("Control_GalleryRanks", "ChannelPhoto", new RouteValueDictionary(defaultRouteValues) { { "sortBy", UserCategorySortBy.PhotoCount} })%>'); return false;">
                <span><%= GetResourceString("Label_ImageMore",applicatonID)%></span></a>
        </li>
    </ul>
    <div class="ui-tabs-panel ui-widget-content ui-corner-bottom">
        <%
        if (Model != null && Model.TotalRecords > 0)
          { %>
        <ul class="tn-photo-list tn-widget tn-helper-reset tn-helper-clearfix">
            <%foreach (UserCategory userCategory in ViewData.Model.Records)
              {  %>
            <li class="tn-album-item tn-helper-clearfix">
                <div class="tn-album-cover tn-widget-content tn-border-gray">
                    <div class="tn-photo-wrap tn-widget-content tn-border-gray">
                        <a href="<%=SiteUrls.Instance().ShowPhotoCategory(UserID2UserNameDictionary.GetUserName(userCategory.UserID),userCategory.CategoryID) %>">
                            <img src="<%=SiteUrls.Instance().CategoryFeaturedPhotoUrl(userCategory) %>" alt="<%=userCategory.CategoryName %>"></a></div>
                </div>
                <p class="tn-text-heading">
                    <a href="<%=SiteUrls.Instance().ShowPhotoCategory(UserID2UserNameDictionary.GetUserName(userCategory.UserID),userCategory.CategoryID) %>"
                        title="<%=userCategory.CategoryName %>">
                        <%=StringUtils.Trim(userCategory.CategoryName,7,string.Empty) %></a></p>
                <p class="tn-text-note tn-date">
                    <%if (sortBy == UserCategorySortBy.MostRecentUpdateDate)
                      {%>
                    <%=Formatter.FormatFriendlyDate(userCategory.MostRecentUpdateDate,false) %>
                    <%}
                      else
                      {%>
                    <%Response.Write(string.Format(GetResourceString("Label_PictureCount", applicatonID) + GetResourceString("Common_Colon") + "{0}", userCategory.ItemCount));%>
                    <%} %>
                </p>
            </li>
            <%} %>
        </ul>
        <div class="tn-pagination tn-helper-align-center">
            <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 7, SPBUrlHelper.Action("Control_GalleryRanks", "ChannelPhoto", new RouteValueDictionary(defaultRouteValues) { { "sortBy", sortBy }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
            <div class="tn-page-results tn-text-note">
                <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
        </div>
        <%}%>
    </div>
</div>

<script type="text/javascript">
    function pageIndexChange(url) {
        $('#galleryRanks').parent().load(url);
    }
</script>

