﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<UserCategory>>" %>
<% UserCategorySortBy sortBy = UserCategorySortBy.MostRecentUpdateDate;
   if (ViewData["sortBy"] != null)
       sortBy = (UserCategorySortBy)ViewData["sortBy"]; %>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-albums-block">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=ViewData.GetString("titleName", GetResourceString("Title_NewCallery", ApplicationIDs.Instance().Photo()))%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-album-list tn-widget tn-helper-clearfix">
      <%foreach (UserCategory category in ViewData.Model)
              {%>
      <li class="tn-album-item tn-helper-clearfix">
        <div class="tn-album-cover tn-widget-content tn-border-gray">
          <div class="tn-photo-wrap tn-widget-content tn-border-gray"> <a href="<%=SiteUrls.Instance().ShowPhotoCategory(UserID2UserNameDictionary.GetUserName(category.UserID),category.CategoryID) %>"> <img src="<%=SiteUrls.Instance().CategoryFeaturedPhotoUrl(category) %>" alt="<%=category.CategoryName %>" /> </a> </div>
        </div>
        <p class="tn-text-heading"> <a title="<%=category.CategoryName%>" target="_blank" href="<%=SiteUrls.Instance().ShowPhotoCategory(UserID2UserNameDictionary.GetUserName(category.UserID),category.CategoryID) %>"> <%=StringUtils.Trim(category.CategoryName,7,string.Empty)%></a></p>
        <p class="tn-text-note tn-count">
          <%switch (sortBy)
                      {
                          case UserCategorySortBy.MostRecentUpdateDate:
                              Response.Write(Formatter.FormatDate(category.DateCreated, false));
                              break;

                          case UserCategorySortBy.PhotoCount:
                              Response.Write(GetResourceString("Label_PictureCount", ApplicationIDs.Instance().Photo()) + GetResourceString("Common_Colon") + category.ItemCount.ToString());
                              break;

                      } %>
        </p>
      </li>
      <%} %>
    </ul>
    <p class="tn-more"><a href="<%=SPBUrlHelper.Action("GalleryRanks","ChannelPhoto",new RouteValueDictionary{{"sortBy",sortBy}}) %>"> <%=GetResourceString("Action_More")%></a></p>
  </div>
</div>
<div class="tn-blank10"> </div>
