﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<PhotoThread>>" %>
<% PhotoSortBy sortBy = PhotoSortBy.MostRecent;
   if (ViewData["sortBy"] != null)
       sortBy = (PhotoSortBy)ViewData["sortBy"]; %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-photos-main">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=ViewData.GetString("titleName", GetResourceString("Title_NewImage",ApplicationIDs.Instance().Photo()))%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-photo-list tn-widget tn-helper-clearfix">
      <%foreach (PhotoThread photo in ViewData.Model)
              {%>
      <%PhotoSection photoSection = photo.Section;%>
      <li class="tn-photo-item">
        <p class="tn-photo-wrap tn-widget-content tn-border-gray"> <a title="<%=photo.Subject %>" href="<%=SPBUrlHelper.Action("ShowPhoto","Photo",new RouteValueDictionary{{"userDomainName",UserID2UserNameDictionary.GetUserName(photo.OwnerUserID)},{"threadID",photo.ThreadID}}) %>"
                        target="_blank"> <%=SPBHtmlHelper.Instance().ShowPicture(photo.ThreadID, PhotoImageType.Thumbnail, photo.Subject)%></a></p>
        <p class="tn-text-heading"> <a href="<%=SPBUrlHelper.Action("ShowPhoto","Photo",new RouteValueDictionary{{"userDomainName",UserID2UserNameDictionary.GetUserName(photo.OwnerUserID)},{"threadID",photo.ThreadID}}) %>"
                        target="_blank" title="<%=photo.Subject%>"> <%=StringUtils.Trim(photo.Subject,9,string.Empty)%></a></p>
        <p class="tn-text-note tn-date">
          <% switch (sortBy)
                       {
                           case PhotoSortBy.MostRecent:
                               Response.Write(string.Format("{0}:<a href=\"{1}\">{2}</a>", GetResourceString("Label_Pattern_Upload", ApplicationIDs.Instance().Photo()), SiteUrls.Instance().UserChannelHome(photo.OwnerUserID, ApplicationIDs.Instance().Photo()), photo.Author));
                               break;
                           case PhotoSortBy.RatingSum:
                               Response.Write(string.Format(GetResourceString("Label_Pattern_Grades", ApplicationIDs.Instance().Photo()) + GetResourceString("Common_Colon"), photo.RatingSum));
                               break;
                           case PhotoSortBy.StickyAndMostRecent:
                               break;
                           case PhotoSortBy.TotalReplies:
                               Response.Write(string.Format(GetResourceString("Common_Comment") + ":{0}", photo.CommentCount));
                               break;
                           case PhotoSortBy.TotalViews:
                               Response.Write(string.Format(GetResourceString("Label_Pattern_OnClick", ApplicationIDs.Instance().Photo()), GetResourceString("Common_Colon") + photo.HitTimes));
                               break;
                           default:
                               Response.Write(string.Format("{0}:<a href=\"{1}\">{2}</a>", GetResourceString("Label_Pattern_Upload", ApplicationIDs.Instance().Photo()) + GetResourceString("Common_Colon"), SiteUrls.Instance().UserChannelHome(photo.OwnerUserID, ApplicationIDs.Instance().Photo()), photo.Author));
                               break;
                       } %>
        </p>
      </li>
      <%} %>
    </ul>
    <p class="tn-more"><a href="<%=SPBUrlHelper.Action("ListPhotosByCategory","ChannelPhoto",new RouteValueDictionary{{"sortBy",sortBy}}) %>"> <%=GetResourceString("Action_More")%></a></p>
  </div>
</div>
<div class="tn-blank10"> </div>
