﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<PhotoThread>>" %>
<div id="listPhotosByCategory" class="ui-tabs ui-widget ui-widget-content ui-corner-all spb-photos-main spb-photos-top">
    <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
        <% PhotoSortBy sortBy = PhotoSortBy.MostRecent;
           if (ViewData["sortBy"] != null)
               sortBy = (PhotoSortBy)ViewData["sortBy"];
           int? categoryID = (int?)ViewData["categoryID"];
           int pageSize = Html.GetParameterFromRouteDateOrQueryString("pageSize", 32);
           RouteValueDictionary defaultRouteValues = new RouteValueDictionary { { "categoryID", categoryID }, { "pageSize", pageSize } };
        %>
        <li <% if (sortBy == PhotoSortBy.MostRecent) Response.Write("class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\""); else  Response.Write("class=\"ui-state-default ui-corner-top\""); %>>
            <a href="<%=SPBUrlHelper.Action("ListPhotosByCategory","ChannelPhoto",new RouteValueDictionary(defaultRouteValues){{"sortBy",PhotoSortBy.MostRecent}}) %>"
                onclick="$('#listPhotosByCategory').parent().load('<%=SPBUrlHelper.Action("Control_ListPhotosByCategory","ChannelPhoto",new RouteValueDictionary(defaultRouteValues){{"sortBy",PhotoSortBy.MostRecent}}) %>'); return false;">
                <span><%=GetResourceString("Title_NewPost") %></span></a></li>
        <li <% if (sortBy == PhotoSortBy.TotalViews) Response.Write("class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\""); else  Response.Write("class=\"ui-state-default ui-corner-top\""); %>>
            <a href="<%=SPBUrlHelper.Action("ListPhotosByCategory","ChannelPhoto",new RouteValueDictionary{{"sortBy",PhotoSortBy.TotalViews}}) %>"
                onclick="$('#listPhotosByCategory').parent().load('<%=SPBUrlHelper.Action("Control_ListPhotosByCategory", "ChannelPhoto", new RouteValueDictionary(defaultRouteValues) {{ "sortBy", PhotoSortBy.TotalViews } })%>'); return false;">
                <span><%=GetResourceString("Label_VisitMore",ApplicationIDs.Instance().Photo()) %></span>
            </a></li>
        <li <% if (sortBy == PhotoSortBy.TotalReplies) Response.Write("class=\"ui-state-default ui-corner-top ui-tabs-selected ui-state-active\""); else  Response.Write("class=\"ui-state-default ui-corner-top\""); %>>
            <a href="<%=SPBUrlHelper.Action("ListPhotosByCategory","ChannelPhoto",new RouteValueDictionary{{"sortBy",PhotoSortBy.TotalReplies}}) %>"
                onclick="$('#listPhotosByCategory').parent().load('<%=SPBUrlHelper.Action("Control_ListPhotosByCategory", "ChannelPhoto", new RouteValueDictionary(defaultRouteValues) {{ "sortBy", PhotoSortBy.TotalReplies } })%>'); return false;">
                <span><%=GetResourceString("Title_CommentMost") %></span></a></li>
    </ul>
    <div class="ui-tabs-panel ui-widget-content ui-corner-bottom">
        <ul class="tn-photo-list tn-widget tn-helper-reset tn-helper-clearfix">
            <%foreach (PhotoThread photo in ViewData.Model.Records)
              {%>
            <li class="tn-photo-item">
                <p class="tn-photo-wrap tn-helper-reset tn-widget-content tn-border-gray">
                    <a href="<%=SPBUrlHelper.Action("ShowPhoto","Photo",new RouteValueDictionary{{"userDomainName",UserID2UserNameDictionary.GetUserName(photo.OwnerUserID)},{"threadID",photo.ThreadID}}) %>"
                        class="pohotListImg" target="_blank">
                        <%=SPBHtmlHelper.Instance().ShowPicture(photo.ThreadID, PhotoImageType.Thumbnail,photo.Subject) %></a>
                </p>
                <p class="tn-helper-reset tn-text-heading">
                    <a href="<%=SPBUrlHelper.Action("ShowPhoto","Photo",new RouteValueDictionary{{"userDomainName",UserID2UserNameDictionary.GetUserName(photo.OwnerUserID)},{"threadID",photo.ThreadID}}) %>"
                        target="_blank" title="<%=photo.Subject %>">
                        <%=StringUtils.Trim(photo.Subject,9,string.Empty)%></a></p>
                <p class="tn-helper-reset tn-text-note <% switch (sortBy) { case PhotoSortBy.MostRecent: Response.Write(" tn-date"); break; case PhotoSortBy.RatingSum: case PhotoSortBy.TotalReplies: case PhotoSortBy.TotalViews: Response.Write(" tn-count"); break; default: Response.Write(""); break; } %>">
                    <% switch (sortBy)
                       {
                           case PhotoSortBy.MostRecent:
                               Response.Write(Formatter.FormatFriendlyDate(photo.PostDate,false));
                               break;
                           case PhotoSortBy.TotalReplies:
                               Response.Write(string.Format(GetResourceString("Common_Comment") + GetResourceString("Common_Colon") + "{0}", photo.CommentCount));
                               break;
                           case PhotoSortBy.TotalViews:
                               Response.Write(string.Format(GetResourceString("Label_Pattern_OnClick", ApplicationIDs.Instance().Photo()), GetResourceString("Common_Colon") + photo.HitTimes));
                               break;
                           default:
                               Response.Write(Formatter.FormatFriendlyDate(photo.PostDate,false));
                               break;
                       } %>
                </p>
            </li>
            <%}%>
        </ul>
        <div class="tn-pagination tn-helper-align-center">
            <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListPhotosByCategory", "ChannelPhoto", new RouteValueDictionary(defaultRouteValues) { { "sortBy", sortBy }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
            <div class="tn-page-results tn-text-note">
                <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
        </div>
    </div>

    <script type="text/javascript">
        function pageIndexChange(url) {
            $('#listPhotosByCategory').parent().load(url);
        }
    </script>

</div>
